/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.MessageHandler;
import io.nats.client.support.Validator;
import io.nats.service.Service;
import io.nats.service.ServiceUtil;
import io.nats.service.StatsData;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;

public class ServiceBuilder {
    Connection conn;
    String name;
    String description;
    String version;
    String subject;
    String schemaRequest;
    String schemaResponse;
    MessageHandler serviceMessageHandler;
    Dispatcher dUserDiscovery;
    Dispatcher dUserService;
    Supplier<StatsData> statsDataSupplier;
    Function<String, StatsData> statsDataDecoder;
    Duration drainTimeout = ServiceUtil.DEFAULT_DRAIN_TIMEOUT;

    public ServiceBuilder connection(Connection conn) {
        this.conn = conn;
        return this;
    }

    public ServiceBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ServiceBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ServiceBuilder version(String version) {
        this.version = version;
        return this;
    }

    public ServiceBuilder subject(String subject) {
        this.subject = subject;
        return this;
    }

    public ServiceBuilder schemaRequest(String schemaRequest) {
        this.schemaRequest = schemaRequest;
        return this;
    }

    public ServiceBuilder schemaResponse(String schemaResponse) {
        this.schemaResponse = schemaResponse;
        return this;
    }

    public ServiceBuilder serviceMessageHandler(MessageHandler userMessageHandler) {
        this.serviceMessageHandler = userMessageHandler;
        return this;
    }

    public ServiceBuilder userDiscoveryDispatcher(Dispatcher dUserDiscovery) {
        this.dUserDiscovery = dUserDiscovery;
        return this;
    }

    public ServiceBuilder userServiceDispatcher(Dispatcher dUserService) {
        this.dUserService = dUserService;
        return this;
    }

    public ServiceBuilder statsDataHandlers(Supplier<StatsData> statsDataSupplier, Function<String, StatsData> statsDataDecoder) {
        this.statsDataSupplier = statsDataSupplier;
        this.statsDataDecoder = statsDataDecoder;
        return this;
    }

    public ServiceBuilder drainTimeout(Duration drainTimeout) {
        this.drainTimeout = drainTimeout;
        return this;
    }

    public Service build() {
        Validator.required(this.conn, "Connection");
        Validator.required(this.serviceMessageHandler, "Service Message Handler");
        Validator.validateIsRestrictedTerm(this.name, "Name", true);
        Validator.validateSemVer(this.version, "Version", true);
        if (this.statsDataSupplier != null && this.statsDataDecoder == null || this.statsDataSupplier == null && this.statsDataDecoder != null) {
            throw new IllegalArgumentException("You must provide neither or both the stats data supplier and decoder");
        }
        return new Service(this);
    }
}

