/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsMessage;
import java.nio.charset.StandardCharsets;

public abstract class ServiceMessage {
    public static final String NATS_SERVICE_ERROR = "Nats-Service-Error";
    public static final String NATS_SERVICE_ERROR_CODE = "Nats-Service-Error-Code";

    public static void reply(Connection conn, Message request, byte[] data) {
        conn.publish(request.getReplyTo(), data);
    }

    public static void reply(Connection conn, Message request, String data) {
        conn.publish(request.getReplyTo(), data.getBytes(StandardCharsets.UTF_8));
    }

    public static void reply(Connection conn, Message request, byte[] data, Headers headers) {
        conn.publish(NatsMessage.builder().subject(request.getReplyTo()).data(data).headers(headers).build());
    }

    public static void reply(Connection conn, Message request, String data, Headers headers) {
        conn.publish(NatsMessage.builder().subject(request.getReplyTo()).data(data).headers(headers).build());
    }

    public static void replyStandardError(Connection conn, Message request, String errorMessage, int errorCode) {
        conn.publish(NatsMessage.builder().subject(request.getReplyTo()).headers(new Headers().put(NATS_SERVICE_ERROR, errorMessage).put(NATS_SERVICE_ERROR_CODE, "" + errorCode)).build());
    }
}

