/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.Validator;
import java.time.Duration;

public class ServiceUtil {
    public static final String PING = "PING";
    public static final String INFO = "INFO";
    public static final String SCHEMA = "SCHEMA";
    public static final String STATS = "STATS";
    public static final String DEFAULT_SERVICE_PREFIX = "$SRV.";
    public static final String QGROUP = "q";
    public static final Duration DEFAULT_DRAIN_TIMEOUT = Duration.ofSeconds(5L);
    public static final long DEFAULT_DISCOVERY_MAX_TIME_MILLIS = 5000L;
    public static final int DEFAULT_DISCOVERY_MAX_RESULTS = 10;

    public static String toDiscoverySubject(String discoverySubject, String optionalServiceNameSegment, String optionalServiceIdSegment) {
        if (Validator.nullOrEmpty(optionalServiceIdSegment)) {
            if (Validator.nullOrEmpty(optionalServiceNameSegment)) {
                return DEFAULT_SERVICE_PREFIX + discoverySubject;
            }
            return DEFAULT_SERVICE_PREFIX + discoverySubject + "." + optionalServiceNameSegment;
        }
        return DEFAULT_SERVICE_PREFIX + discoverySubject + "." + optionalServiceNameSegment + "." + optionalServiceIdSegment;
    }
}

