/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.service.StatsData;
import java.time.ZonedDateTime;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class StatsResponse
implements JsonSerializable {
    public static final String TYPE = "io.nats.micro.v1.stats_response";
    private final String serviceId;
    private final String name;
    private final String version;
    private final AtomicLong numRequests;
    private final AtomicLong numErrors;
    private final AtomicReference<String> lastError;
    private final AtomicLong processingTime;
    private final AtomicLong averageProcessingTime;
    private StatsData data;
    private ZonedDateTime started;

    public StatsResponse(String serviceId, String name, String version) {
        this.serviceId = serviceId;
        this.name = name;
        this.version = version;
        this.numRequests = new AtomicLong();
        this.numErrors = new AtomicLong();
        this.lastError = new AtomicReference();
        this.processingTime = new AtomicLong();
        this.averageProcessingTime = new AtomicLong();
        this.started = DateTimeUtils.gmtNow();
    }

    public StatsResponse copy(Function<String, StatsData> decoder) {
        StatsResponse copy = new StatsResponse(this.serviceId, this.name, this.version);
        copy.numRequests.set(this.numRequests.get());
        copy.numErrors.set(this.numErrors.get());
        copy.lastError.set(this.lastError.get());
        copy.processingTime.set(this.processingTime.get());
        copy.averageProcessingTime.set(this.averageProcessingTime.get());
        if (this.data != null && decoder != null) {
            copy.data = decoder.apply(this.data.toJson());
        }
        copy.started = DateTimeUtils.toGmt(this.started);
        return copy;
    }

    public StatsResponse(String json, Function<String, StatsData> decoder) {
        String dataJson = JsonUtils.getJsonObject("data", json, null);
        if (dataJson != null) {
            if (decoder != null) {
                this.data = decoder.apply(dataJson);
            }
            JsonUtils.removeObject(json, "data");
        }
        this.name = JsonUtils.readString(json, ApiConstants.NAME_RE);
        this.serviceId = JsonUtils.readString(json, ApiConstants.ID_RE);
        this.version = JsonUtils.readString(json, ApiConstants.VERSION_RE);
        this.numRequests = new AtomicLong(JsonUtils.readLong(json, ApiConstants.NUM_REQUESTS_RE, 0L));
        this.numErrors = new AtomicLong(JsonUtils.readLong(json, ApiConstants.NUM_ERRORS_RE, 0L));
        this.lastError = new AtomicReference<String>(JsonUtils.readString(json, ApiConstants.LAST_ERROR_RE));
        this.processingTime = new AtomicLong(JsonUtils.readLong(json, ApiConstants.PROCESSING_TIME_RE, 0L));
        this.averageProcessingTime = new AtomicLong(JsonUtils.readLong(json, ApiConstants.AVERAGE_PROCESSING_TIME_RE, 0L));
        this.started = JsonUtils.readDate(json, ApiConstants.STARTED_RE);
    }

    public void reset() {
        this.numRequests.set(0L);
        this.numErrors.set(0L);
        this.lastError.set(null);
        this.processingTime.set(0L);
        this.averageProcessingTime.set(0L);
        this.data = null;
        this.started = DateTimeUtils.gmtNow();
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "type", TYPE);
        JsonUtils.addField(sb, "id", this.serviceId);
        JsonUtils.addField(sb, "version", this.version);
        JsonUtils.addField(sb, "num_requests", this.numRequests.get());
        JsonUtils.addField(sb, "num_errors", this.numErrors.get());
        JsonUtils.addField(sb, "last_error", this.lastError.get());
        JsonUtils.addField(sb, "processing_time", this.processingTime.get());
        JsonUtils.addField(sb, "average_processing_time", this.averageProcessingTime.get());
        if (this.data != null) {
            JsonUtils.addRawJson(sb, "data", this.data.toJson());
        }
        JsonUtils.addField(sb, "started", this.started);
        return JsonUtils.endJson(sb).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return TYPE;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getVersion() {
        return this.version;
    }

    public long getNumRequests() {
        return this.numRequests.get();
    }

    public long getNumErrors() {
        return this.numErrors.get();
    }

    public String getLastError() {
        return this.lastError.get();
    }

    public long getProcessingTime() {
        return this.processingTime.get();
    }

    public long getAverageProcessingTime() {
        return this.averageProcessingTime.get();
    }

    public StatsData getData() {
        return this.data;
    }

    public ZonedDateTime getStarted() {
        return this.started;
    }

    public long incrementNumRequests() {
        return this.numRequests.incrementAndGet();
    }

    public void incrementNumErrors() {
        this.numErrors.incrementAndGet();
    }

    public void setLastError(String lastError) {
        this.lastError.set(lastError);
    }

    public long addTotalProcessingTime(long elapsed) {
        return this.processingTime.addAndGet(elapsed);
    }

    public void setAverageProcessingTime(long averageProcessingTime) {
        this.averageProcessingTime.set(averageProcessingTime);
    }

    public void setData(StatsData data) {
        this.data = data;
    }

    public String toString() {
        return this.toJson();
    }
}

