/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service.context;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.service.ServiceMessage;
import io.nats.service.StatsResponse;

public abstract class Context {
    protected final Connection conn;
    protected final StatsResponse statsResponse;
    protected final String subject;
    protected final Dispatcher dispatcher;
    protected final boolean isInternalDispatcher;
    protected final boolean recordStats;
    protected final String qGroup;
    protected Subscription sub;

    public Context(Connection conn, String subject, Dispatcher dispatcher, boolean isInternalDispatcher, StatsResponse statsResponse, boolean isServiceContext) {
        this.conn = conn;
        this.subject = subject;
        this.dispatcher = dispatcher;
        this.isInternalDispatcher = isInternalDispatcher;
        this.statsResponse = statsResponse;
        this.recordStats = isServiceContext;
        this.qGroup = isServiceContext ? "q" : null;
    }

    public void start() {
        this.sub = this.qGroup == null ? this.dispatcher.subscribe(this.subject, this::onMessage) : this.dispatcher.subscribe(this.subject, this.qGroup, this::onMessage);
    }

    protected abstract void subOnMessage(Message var1) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) throws InterruptedException {
        long requestNo = this.recordStats ? this.statsResponse.incrementNumRequests() : -1L;
        long start = 0L;
        try {
            start = System.nanoTime();
            this.subOnMessage(msg);
        }
        catch (Throwable t) {
            if (this.recordStats) {
                this.statsResponse.incrementNumErrors();
                this.statsResponse.setLastError(t.toString());
            }
            try {
                ServiceMessage.replyStandardError(this.conn, msg, t.getMessage(), 500);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (this.recordStats) {
                long total = this.statsResponse.addTotalProcessingTime(System.nanoTime() - start);
                this.statsResponse.setAverageProcessingTime(total / requestNo);
            }
        }
    }

    public Context setSub(Subscription sub) {
        this.sub = sub;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public boolean isInternalDispatcher() {
        return this.isInternalDispatcher;
    }

    public StatsResponse getStats() {
        return this.statsResponse;
    }

    public Subscription getSub() {
        return this.sub;
    }
}

