/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.SubscribeOptions;
import io.nats.client.support.Validator;

public class PushSubscribeOptions
extends SubscribeOptions {
    private PushSubscribeOptions(Builder builder, boolean ordered, String deliverSubject, String deliverGroup, long pendingMessageLimit, long pendingByteLimit) {
        super(builder, false, ordered, deliverSubject, deliverGroup, pendingMessageLimit, pendingByteLimit);
    }

    public String getDeliverSubject() {
        return this.consumerConfig.getDeliverSubject();
    }

    public String getDeliverGroup() {
        return this.consumerConfig.getDeliverGroup();
    }

    @Deprecated
    public static PushSubscribeOptions bind(String stream) {
        return PushSubscribeOptions.stream(stream);
    }

    public static PushSubscribeOptions stream(String stream) {
        return ((Builder)new Builder().stream(stream)).build();
    }

    public static PushSubscribeOptions bind(String stream, String durable) {
        return ((Builder)((Builder)((Builder)new Builder().stream(stream)).durable(durable)).bind(true)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SubscribeOptions.Builder<Builder, PushSubscribeOptions> {
        private boolean ordered;
        private String deliverSubject;
        private String deliverGroup;
        private long pendingMessageLimit = 524288L;
        private long pendingByteLimit = 0x4000000L;

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder ordered(boolean ordered) {
            this.ordered = ordered;
            return this;
        }

        public Builder deliverSubject(String deliverSubject) {
            this.deliverSubject = Validator.emptyAsNull(deliverSubject);
            return this;
        }

        public Builder deliverGroup(String deliverGroup) {
            this.deliverGroup = Validator.emptyAsNull(deliverGroup);
            return this;
        }

        public Builder pendingMessageLimit(long pendingMessageLimit) {
            this.pendingMessageLimit = pendingMessageLimit;
            return this;
        }

        public Builder pendingByteLimit(long pendingByteLimit) {
            this.pendingByteLimit = pendingByteLimit;
            return this;
        }

        @Override
        public PushSubscribeOptions build() {
            return new PushSubscribeOptions(this, this.ordered, this.deliverSubject, this.deliverGroup, this.pendingMessageLimit, this.pendingByteLimit);
        }
    }
}

