/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.NUID;
import io.nats.client.Subscription;
import io.nats.service.InfoResponse;
import io.nats.service.PingResponse;
import io.nats.service.SchemaResponse;
import io.nats.service.Service;
import io.nats.service.StatsResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class Discovery {
    public static final long DEFAULT_DISCOVERY_MAX_TIME_MILLIS = 5000L;
    public static final int DEFAULT_DISCOVERY_MAX_RESULTS = 10;
    private final Connection conn;
    private final long maxTimeMillis;
    private final int maxResults;

    public Discovery(Connection conn) {
        this(conn, -1L, -1);
    }

    public Discovery(Connection conn, long maxTimeMillis, int maxResults) {
        this.conn = conn;
        this.maxTimeMillis = maxTimeMillis < 1L ? 5000L : maxTimeMillis;
        this.maxResults = maxResults < 1 ? 10 : maxResults;
    }

    public List<PingResponse> ping() {
        return this.ping(null);
    }

    public List<PingResponse> ping(String serviceName) {
        ArrayList<PingResponse> list = new ArrayList<PingResponse>();
        this.discoverMany("PING", serviceName, jsonBytes -> list.add(new PingResponse((byte[])jsonBytes)));
        return list;
    }

    public PingResponse ping(String serviceName, String serviceId) {
        byte[] jsonBytes = this.discoverOne("PING", serviceName, serviceId);
        return jsonBytes == null ? null : new PingResponse(jsonBytes);
    }

    public List<InfoResponse> info() {
        return this.info(null);
    }

    public List<InfoResponse> info(String serviceName) {
        ArrayList<InfoResponse> list = new ArrayList<InfoResponse>();
        this.discoverMany("INFO", serviceName, jsonBytes -> list.add(new InfoResponse((byte[])jsonBytes)));
        return list;
    }

    public InfoResponse info(String serviceName, String serviceId) {
        byte[] jsonBytes = this.discoverOne("INFO", serviceName, serviceId);
        return jsonBytes == null ? null : new InfoResponse(jsonBytes);
    }

    public List<SchemaResponse> schema() {
        return this.schema(null);
    }

    public List<SchemaResponse> schema(String serviceName) {
        ArrayList<SchemaResponse> list = new ArrayList<SchemaResponse>();
        this.discoverMany("SCHEMA", serviceName, jsonBytes -> list.add(new SchemaResponse((byte[])jsonBytes)));
        return list;
    }

    public SchemaResponse schema(String serviceName, String serviceId) {
        byte[] jsonBytes = this.discoverOne("SCHEMA", serviceName, serviceId);
        return jsonBytes == null ? null : new SchemaResponse(jsonBytes);
    }

    public List<StatsResponse> stats() {
        return this.stats(null);
    }

    public List<StatsResponse> stats(String serviceName) {
        ArrayList<StatsResponse> list = new ArrayList<StatsResponse>();
        this.discoverMany("STATS", serviceName, jsonBytes -> list.add(new StatsResponse((byte[])jsonBytes)));
        return list;
    }

    public StatsResponse stats(String serviceName, String serviceId) {
        byte[] jsonBytes = this.discoverOne("STATS", serviceName, serviceId);
        return jsonBytes == null ? null : new StatsResponse(jsonBytes);
    }

    private byte[] discoverOne(String action, String serviceName, String serviceId) {
        String subject = Service.toDiscoverySubject(action, serviceName, serviceId);
        try {
            Message m = this.conn.request(subject, null, Duration.ofMillis(this.maxTimeMillis));
            if (m != null) {
                return m.getData();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverMany(String action, String serviceName, Consumer<byte[]> dataConsumer) {
        Subscription sub = null;
        try {
            StringBuilder sb = new StringBuilder(NUID.nextGlobal()).append('-').append(action);
            if (serviceName != null) {
                sb.append('-').append(serviceName);
            }
            String replyTo = sb.toString();
            sub = this.conn.subscribe(replyTo);
            String subject = Service.toDiscoverySubject(action, serviceName, null);
            this.conn.publish(subject, replyTo, null);
            long start = System.currentTimeMillis();
            long timeLeft = this.maxTimeMillis;
            for (int resultsLeft = this.maxResults; resultsLeft > 0 && timeLeft > 0L; --resultsLeft) {
                Message msg = sub.nextMessage(timeLeft);
                if (msg == null) {
                    return;
                }
                dataConsumer.accept(msg.getData());
                timeLeft = this.maxTimeMillis - (System.currentTimeMillis() - start);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            try {
                sub.unsubscribe();
            }
            catch (Exception exception) {}
        }
    }
}

