/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.util.Objects;

public class Schema
implements JsonSerializable {
    private final String request;
    private final String response;

    public static Schema optionalInstance(JsonValue vSchema) {
        return vSchema == null ? null : new Schema(vSchema);
    }

    public static Schema optionalInstance(String request, String response) {
        request = Validator.emptyAsNull(request);
        response = Validator.emptyAsNull(response);
        return request == null && response == null ? null : new Schema(request, response);
    }

    public Schema(String request, String response) {
        this.request = request;
        this.response = response;
    }

    protected Schema(JsonValue vSchema) {
        this.request = JsonValueUtils.readString(vSchema, "request");
        this.response = JsonValueUtils.readString(vSchema, "response");
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "request", this.request);
        JsonUtils.addField(sb, "response", this.response);
        return JsonUtils.endJson(sb).toString();
    }

    public String toString() {
        return JsonUtils.toKey(this.getClass()) + this.toJson();
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        if (!Objects.equals(this.request, schema.request)) {
            return false;
        }
        return Objects.equals(this.response, schema.response);
    }

    public int hashCode() {
        int result = this.request != null ? this.request.hashCode() : 0;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        return result;
    }
}

