/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.NUID;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import io.nats.service.Endpoint;
import io.nats.service.EndpointContext;
import io.nats.service.EndpointResponse;
import io.nats.service.InfoResponse;
import io.nats.service.PingResponse;
import io.nats.service.SchemaResponse;
import io.nats.service.ServiceBuilder;
import io.nats.service.ServiceEndpoint;
import io.nats.service.ServiceMessageHandler;
import io.nats.service.ServiceResponse;
import io.nats.service.StatsResponse;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class Service {
    public static final String SRV_PING = "PING";
    public static final String SRV_INFO = "INFO";
    public static final String SRV_SCHEMA = "SCHEMA";
    public static final String SRV_STATS = "STATS";
    public static final String DEFAULT_SERVICE_PREFIX = "$SRV.";
    private final Connection conn;
    private final Duration drainTimeout;
    private final Map<String, EndpointContext> serviceContexts;
    private final List<EndpointContext> discoveryContexts;
    private final List<Dispatcher> dInternals;
    private final PingResponse pingResponse;
    private final InfoResponse infoResponse;
    private final SchemaResponse schemaResponse;
    private final Object stopLock;
    private CompletableFuture<Boolean> doneFuture;
    private ZonedDateTime started;

    Service(ServiceBuilder b) {
        String id = new NUID().next();
        this.conn = b.conn;
        this.drainTimeout = b.drainTimeout;
        this.dInternals = new ArrayList<Dispatcher>();
        this.stopLock = new Object();
        Dispatcher dTemp = null;
        ArrayList<String> infoSubjects = new ArrayList<String>();
        ArrayList<EndpointResponse> schemaEndpoints = new ArrayList<EndpointResponse>();
        this.serviceContexts = new HashMap<String, EndpointContext>();
        for (ServiceEndpoint se : b.serviceEndpoints.values()) {
            if (se.getDispatcher() == null) {
                if (dTemp == null) {
                    dTemp = this.conn.createDispatcher();
                }
                this.serviceContexts.put(se.getName(), new EndpointContext(this.conn, dTemp, true, se));
            } else {
                this.serviceContexts.put(se.getName(), new EndpointContext(this.conn, null, true, se));
            }
            infoSubjects.add(se.getSubject());
            schemaEndpoints.add(new EndpointResponse(se.getName(), se.getSubject(), se.getEndpoint().getSchema()));
        }
        if (dTemp != null) {
            this.dInternals.add(dTemp);
        }
        this.pingResponse = new PingResponse(id, b.name, b.version);
        this.infoResponse = new InfoResponse(id, b.name, b.version, b.description, infoSubjects);
        this.schemaResponse = new SchemaResponse(id, b.name, b.version, b.apiUrl, schemaEndpoints);
        if (b.pingDispatcher == null || b.infoDispatcher == null || b.schemaDispatcher == null || b.statsDispatcher == null) {
            dTemp = this.conn.createDispatcher();
            this.dInternals.add(dTemp);
        } else {
            dTemp = null;
        }
        this.discoveryContexts = new ArrayList<EndpointContext>();
        this.addDiscoveryContexts(SRV_PING, this.pingResponse, b.pingDispatcher, dTemp);
        this.addDiscoveryContexts(SRV_INFO, this.infoResponse, b.infoDispatcher, dTemp);
        this.addDiscoveryContexts(SRV_SCHEMA, this.schemaResponse, b.schemaDispatcher, dTemp);
        this.addStatsContexts(b.statsDispatcher, dTemp);
    }

    private void addDiscoveryContexts(String discoveryName, Dispatcher dUser, Dispatcher dInternal, ServiceMessageHandler handler) {
        Endpoint[] endpoints;
        for (Endpoint endpoint : endpoints = new Endpoint[]{this.internalEndpoint(discoveryName, null, null), this.internalEndpoint(discoveryName, this.pingResponse.getName(), null), this.internalEndpoint(discoveryName, this.pingResponse.getName(), this.pingResponse.getId())}) {
            this.discoveryContexts.add(new EndpointContext(this.conn, dInternal, false, new ServiceEndpoint(endpoint, handler, dUser)));
        }
    }

    private void addDiscoveryContexts(String discoveryName, ServiceResponse sr, Dispatcher dUser, Dispatcher dInternal) {
        byte[] responseBytes = sr.serialize();
        ServiceMessageHandler handler = smsg -> smsg.respond(this.conn, responseBytes);
        this.addDiscoveryContexts(discoveryName, dUser, dInternal, handler);
    }

    private void addStatsContexts(Dispatcher dUser, Dispatcher dInternal) {
        ServiceMessageHandler handler = smsg -> smsg.respond(this.conn, this.getStatsResponse().serialize());
        this.addDiscoveryContexts(SRV_STATS, dUser, dInternal, handler);
    }

    private Endpoint internalEndpoint(String discoveryName, String optionalServiceNameSegment, String optionalServiceIdSegment) {
        String subject = Service.toDiscoverySubject(discoveryName, optionalServiceNameSegment, optionalServiceIdSegment);
        return new Endpoint(subject, subject, null, false);
    }

    static String toDiscoverySubject(String discoveryName, String optionalServiceNameSegment, String optionalServiceIdSegment) {
        if (Validator.nullOrEmpty(optionalServiceIdSegment)) {
            if (Validator.nullOrEmpty(optionalServiceNameSegment)) {
                return DEFAULT_SERVICE_PREFIX + discoveryName;
            }
            return DEFAULT_SERVICE_PREFIX + discoveryName + "." + optionalServiceNameSegment;
        }
        return DEFAULT_SERVICE_PREFIX + discoveryName + "." + optionalServiceNameSegment + "." + optionalServiceIdSegment;
    }

    public CompletableFuture<Boolean> startService() {
        this.doneFuture = new CompletableFuture();
        for (EndpointContext ctx : this.serviceContexts.values()) {
            ctx.start();
        }
        for (EndpointContext ctx : this.discoveryContexts) {
            ctx.start();
        }
        this.started = DateTimeUtils.gmtNow();
        return this.doneFuture;
    }

    public static ServiceBuilder builder() {
        return new ServiceBuilder();
    }

    public void stop() {
        this.stop(true, null);
    }

    public void stop(Throwable t) {
        this.stop(true, t);
    }

    public void stop(boolean drain) {
        this.stop(drain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean drain, Throwable t) {
        Object object = this.stopLock;
        synchronized (object) {
            if (!this.doneFuture.isDone()) {
                if (drain) {
                    ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
                    for (Dispatcher d : this.dInternals) {
                        try {
                            futures.add(d.drain(this.drainTimeout));
                        }
                        catch (Exception exception) {}
                    }
                    for (EndpointContext c : this.serviceContexts.values()) {
                        if (!c.isNotInternalDispatcher()) continue;
                        try {
                            futures.add(c.getSub().drain(this.drainTimeout));
                        }
                        catch (Exception exception) {}
                    }
                    for (EndpointContext c : this.discoveryContexts) {
                        if (!c.isNotInternalDispatcher()) continue;
                        try {
                            futures.add(c.getSub().drain(this.drainTimeout));
                        }
                        catch (Exception exception) {}
                    }
                    long drainTimeoutMillis = this.drainTimeout.toMillis();
                    for (CompletableFuture completableFuture : futures) {
                        try {
                            completableFuture.get(drainTimeoutMillis, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception exception) {}
                    }
                }
                for (Dispatcher d : this.dInternals) {
                    this.conn.closeDispatcher(d);
                }
                if (t == null) {
                    this.doneFuture.complete(true);
                } else {
                    this.doneFuture.completeExceptionally(t);
                }
            }
        }
    }

    public void reset() {
        this.started = DateTimeUtils.gmtNow();
        for (EndpointContext c : this.discoveryContexts) {
            c.reset();
        }
        for (EndpointContext c : this.serviceContexts.values()) {
            c.reset();
        }
    }

    public String getId() {
        return this.infoResponse.getId();
    }

    public String getName() {
        return this.infoResponse.getName();
    }

    public String getVersion() {
        return this.infoResponse.getVersion();
    }

    public String getDescription() {
        return this.infoResponse.getDescription();
    }

    public String getApiUrl() {
        return this.schemaResponse.getApiUrl();
    }

    public Duration getDrainTimeout() {
        return this.drainTimeout;
    }

    public PingResponse getPingResponse() {
        return this.pingResponse;
    }

    public InfoResponse getInfoResponse() {
        return this.infoResponse;
    }

    public SchemaResponse getSchemaResponse() {
        return this.schemaResponse;
    }

    public StatsResponse getStatsResponse() {
        ArrayList<EndpointResponse> endpointStats = new ArrayList<EndpointResponse>();
        for (EndpointContext c : this.serviceContexts.values()) {
            endpointStats.add(c.getEndpointStats());
        }
        return new StatsResponse(this.pingResponse, this.started, endpointStats);
    }

    public EndpointResponse getEndpointStats(String endpointName) {
        EndpointContext c = this.serviceContexts.get(endpointName);
        return c == null ? null : c.getEndpointStats();
    }

    public String toString() {
        StringBuilder sb = JsonUtils.beginJsonPrefixed("\"Service\":");
        JsonUtils.addField(sb, "id", this.infoResponse.getId());
        JsonUtils.addField(sb, "name", this.infoResponse.getName());
        JsonUtils.addField(sb, "version", this.infoResponse.getVersion());
        JsonUtils.addField(sb, "description", this.infoResponse.getDescription());
        JsonUtils.addField(sb, "api_url", this.schemaResponse.getApiUrl());
        JsonUtils.addJsons(sb, "endpoints", this.schemaResponse.getEndpoints());
        return JsonUtils.endJson(sb).toString();
    }
}

