/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.Error;
import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;

public abstract class ApiResponse<T> {
    public static final String NO_TYPE = "io.nats.jetstream.api.v1.no_type";
    public static final String PARSE_ERROR_TYPE = "io.nats.client.api.parse_error";
    protected final JsonValue jv;
    private final String type;
    private final Error error;

    public ApiResponse(Message msg) {
        this(ApiResponse.parseMessage(msg));
    }

    protected static JsonValue parseMessage(Message msg) {
        if (msg == null) {
            return null;
        }
        try {
            return JsonParser.parse(msg.getData());
        }
        catch (JsonParseException e) {
            return JsonValueUtils.mapBuilder().put("error", new Error(500, "Error parsing: " + e.getMessage())).put("type", PARSE_ERROR_TYPE).getJsonValue();
        }
    }

    public ApiResponse(JsonValue jsonValue) {
        this.jv = jsonValue;
        if (this.jv == null) {
            this.error = null;
            this.type = null;
        } else {
            this.error = Error.optionalInstance(JsonValueUtils.readValue(this.jv, "error"));
            String temp = JsonValueUtils.readString(this.jv, "type");
            if (temp == null) {
                this.type = NO_TYPE;
            } else {
                this.type = temp;
                this.jv.map.remove("type");
            }
        }
    }

    public ApiResponse() {
        this.jv = null;
        this.error = null;
        this.type = NO_TYPE;
    }

    public T throwOnHasError() throws JetStreamApiException {
        if (this.hasError()) {
            throw new JetStreamApiException(this);
        }
        return (T)this;
    }

    public JsonValue getJv() {
        return this.jv;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getType() {
        return this.type;
    }

    public int getErrorCode() {
        return this.error == null ? -1 : this.error.getCode();
    }

    public int getApiErrorCode() {
        return this.error == null ? -1 : this.error.getApiErrorCode();
    }

    public String getDescription() {
        return this.error == null ? null : this.error.getDescription();
    }

    public String getError() {
        return this.error == null ? null : this.error.toString();
    }

    public Error getErrorObject() {
        return this.error;
    }

    public String toString() {
        return this.jv == null ? JsonUtils.toKey(this.getClass()) + "\":null" : this.jv.toString(this.getClass());
    }
}

