/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Status;

public class Error
implements JsonSerializable {
    public static final int NOT_SET = -1;
    private final JsonValue jv;
    public static final Error JsBadRequestErr = new Error(400, 10003, "bad request");
    public static final Error JsNoMessageFoundErr = new Error(404, 10037, "no message found");

    static Error optionalInstance(JsonValue vError) {
        return vError == null ? null : new Error(vError);
    }

    Error(JsonValue jv) {
        this.jv = jv;
    }

    Error(int code, String desc) {
        this(code, -1, desc);
    }

    Error(int code, int apiErrorCode, String desc) {
        this.jv = JsonValueUtils.mapBuilder().put("code", code).put("err_code", apiErrorCode).put("description", desc).getJsonValue();
    }

    @Override
    public String toJson() {
        return this.jv.toJson();
    }

    @Override
    public JsonValue toJsonValue() {
        return this.jv;
    }

    public int getCode() {
        return JsonValueUtils.readInteger(this.jv, "code", -1);
    }

    public int getApiErrorCode() {
        return JsonValueUtils.readInteger(this.jv, "err_code", -1);
    }

    public String getDescription() {
        return JsonValueUtils.readString(this.jv, "description", "Unknown JetStream Error");
    }

    public String toString() {
        int apiErrorCode = this.getApiErrorCode();
        int code = this.getCode();
        if (apiErrorCode == -1) {
            if (code == -1) {
                return this.getDescription();
            }
            return this.getDescription() + " (" + code + ")";
        }
        if (code == -1) {
            return this.getDescription();
        }
        return this.getDescription() + " [" + apiErrorCode + "]";
    }

    public static Error convert(Status status) {
        switch (status.getCode()) {
            case 404: {
                return JsNoMessageFoundErr;
            }
            case 408: {
                return JsBadRequestErr;
            }
        }
        return new Error(status.getCode(), -1, status.getMessage());
    }
}

