/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.PublishOptions;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.PublishAck;
import io.nats.client.api.StreamInfo;
import io.nats.client.impl.Headers;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStreamImplBase;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsSubscriptionFactory;
import io.nats.client.impl.OrderedManager;
import io.nats.client.impl.PullMessageManager;
import io.nats.client.impl.PushMessageManager;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class NatsJetStream
extends NatsJetStreamImplBase
implements JetStream {
    private static final PushSubscribeOptions DEFAULT_PUSH_OPTS = PushSubscribeOptions.builder().build();
    PushMessageManagerFactory PUSH_MESSAGE_MANAGER_FACTORY = null;
    PullMessageManagerFactory PULL_MESSAGE_MANAGER_FACTORY = PullMessageManager::new;

    public NatsJetStream(NatsConnection connection, JetStreamOptions jsOptions) throws IOException {
        super(connection, jsOptions);
    }

    @Override
    public PublishAck publish(String subject, byte[] body) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, null, body, null);
    }

    @Override
    public PublishAck publish(String subject, Headers headers, byte[] body) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, headers, body, null);
    }

    @Override
    public PublishAck publish(String subject, byte[] body, PublishOptions options) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, null, body, options);
    }

    @Override
    public PublishAck publish(String subject, Headers headers, byte[] body, PublishOptions options) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, headers, body, options);
    }

    @Override
    public PublishAck publish(Message message) throws IOException, JetStreamApiException {
        Validator.validateNotNull(message, "Message");
        return this.publishSyncInternal(message.getSubject(), message.getHeaders(), message.getData(), null);
    }

    @Override
    public PublishAck publish(Message message, PublishOptions options) throws IOException, JetStreamApiException {
        Validator.validateNotNull(message, "Message");
        return this.publishSyncInternal(message.getSubject(), message.getHeaders(), message.getData(), options);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, byte[] body) {
        return this.publishAsyncInternal(subject, null, body, null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, Headers headers, byte[] body) {
        return this.publishAsyncInternal(subject, headers, body, null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, byte[] body, PublishOptions options) {
        return this.publishAsyncInternal(subject, null, body, options, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, Headers headers, byte[] body, PublishOptions options) {
        return this.publishAsyncInternal(subject, headers, body, options, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(Message message) {
        Validator.validateNotNull(message, "Message");
        return this.publishAsyncInternal(message.getSubject(), message.getHeaders(), message.getData(), null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(Message message, PublishOptions options) {
        Validator.validateNotNull(message, "Message");
        return this.publishAsyncInternal(message.getSubject(), message.getHeaders(), message.getData(), options, null);
    }

    private PublishAck publishSyncInternal(String subject, Headers headers, byte[] data, PublishOptions options) throws IOException, JetStreamApiException {
        Headers merged = this.mergePublishOptions(headers, options);
        if (this.jso.isPublishNoAck()) {
            this.conn.publishInternal(subject, null, merged, data);
            return null;
        }
        Duration timeout = options == null ? this.jso.getRequestTimeout() : options.getStreamTimeout();
        Message resp = this.makeInternalRequestResponseRequired(subject, merged, data, timeout, false);
        return this.processPublishResponse(resp, options);
    }

    private CompletableFuture<PublishAck> publishAsyncInternal(String subject, Headers headers, byte[] data, PublishOptions options, Duration knownTimeout) {
        Headers merged = this.mergePublishOptions(headers, options);
        if (this.jso.isPublishNoAck()) {
            this.conn.publishInternal(subject, null, merged, data);
            return null;
        }
        CompletableFuture<Message> future = this.conn.requestFutureInternal(subject, merged, data, knownTimeout, false);
        return future.thenCompose(resp -> {
            try {
                this.responseRequired((Message)resp);
                return CompletableFuture.completedFuture(this.processPublishResponse((Message)resp, options));
            }
            catch (JetStreamApiException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private PublishAck processPublishResponse(Message resp, PublishOptions options) throws IOException, JetStreamApiException {
        String pubStream;
        if (resp.isStatusMessage()) {
            throw new IOException("Error Publishing: " + resp.getStatus().getCode() + " " + resp.getStatus().getMessage());
        }
        PublishAck ack = new PublishAck(resp);
        String ackStream = ack.getStream();
        String string = pubStream = options == null ? null : options.getStream();
        if (pubStream != null && !pubStream.equals(ackStream)) {
            throw new IOException("Expected ack from stream " + pubStream + ", received from: " + ackStream);
        }
        return ack;
    }

    private Headers mergePublishOptions(Headers headers, PublishOptions opts) {
        Headers merged;
        Headers headers2 = merged = headers == null ? null : new Headers(headers);
        if (opts != null) {
            merged = this.mergeNum(merged, "Nats-Expected-Last-Sequence", opts.getExpectedLastSequence());
            merged = this.mergeNum(merged, "Nats-Expected-Last-Subject-Sequence", opts.getExpectedLastSubjectSequence());
            merged = this.mergeString(merged, "Nats-Expected-Last-Msg-Id", opts.getExpectedLastMsgId());
            merged = this.mergeString(merged, "Nats-Expected-Stream", opts.getExpectedStream());
            merged = this.mergeString(merged, "Nats-Msg-Id", opts.getMessageId());
        }
        return merged;
    }

    private Headers mergeNum(Headers h, String key, long value) {
        return value > -1L ? this._mergeNum(h, key, Long.toString(value)) : h;
    }

    private Headers mergeString(Headers h, String key, String value) {
        return Validator.nullOrEmpty(value) ? h : this._mergeNum(h, key, value);
    }

    private Headers _mergeNum(Headers h, String key, String value) {
        if (h == null) {
            h = new Headers();
        }
        return h.add(key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JetStreamSubscription createSubscription(String subject, String queueName, NatsDispatcher dispatcher, MessageHandler userHandler, boolean isAutoAck, PushSubscribeOptions pushSubscribeOptions, PullSubscribeOptions pullSubscribeOptions) throws IOException, JetStreamApiException {
        NatsJetStreamSubscription sub;
        String settledConsumerName;
        ConsumerConfiguration settledServerCC;
        String fnlInboxDeliver;
        String fnlStream;
        String qgroup;
        ConsumerConfiguration userCC;
        String stream;
        SubscribeOptions so;
        boolean isPullMode;
        boolean bl = isPullMode = pullSubscribeOptions != null;
        if (isPullMode) {
            so = pullSubscribeOptions;
            stream = pullSubscribeOptions.getStream();
            userCC = so.getConsumerConfiguration();
            qgroup = null;
            Validator.validateNotSupplied(userCC.getDeliverGroup(), NatsJetStreamClientError.JsSubPullCantHaveDeliverGroup);
            Validator.validateNotSupplied(userCC.getDeliverSubject(), NatsJetStreamClientError.JsSubPullCantHaveDeliverSubject);
        } else {
            so = pushSubscribeOptions == null ? DEFAULT_PUSH_OPTS : pushSubscribeOptions;
            stream = so.getStream();
            userCC = so.getConsumerConfiguration();
            if (userCC.maxPullWaitingWasSet()) {
                throw NatsJetStreamClientError.JsSubPushCantHaveMaxPullWaiting.instance();
            }
            if (userCC.maxBatchWasSet()) {
                throw NatsJetStreamClientError.JsSubPushCantHaveMaxBatch.instance();
            }
            if (userCC.maxBytesWasSet()) {
                throw NatsJetStreamClientError.JsSubPushCantHaveMaxBytes.instance();
            }
            qgroup = Validator.validateMustMatchIfBothSupplied(userCC.getDeliverGroup(), queueName, NatsJetStreamClientError.JsSubQueueDeliverGroupMismatch);
            if (so.isOrdered() && qgroup != null) {
                throw NatsJetStreamClientError.JsSubOrderedNotAllowOnQueues.instance();
            }
            if (dispatcher != null && (so.getPendingMessageLimit() != 524288L || so.getPendingByteLimit() != 0x4000000L)) {
                throw NatsJetStreamClientError.JsSubPushAsyncCantSetPending.instance();
            }
        }
        if (userCC.getIdleHeartbeat() != null && userCC.getIdleHeartbeat().toMillis() > 0L) {
            if (isPullMode) {
                throw NatsJetStreamClientError.JsSubFcHbNotValidPull.instance();
            }
            if (qgroup != null) {
                throw NatsJetStreamClientError.JsSubFcHbNotValidQueue.instance();
            }
        }
        if (stream == null) {
            fnlStream = this.lookupStreamBySubject(subject);
            if (fnlStream == null) {
                throw NatsJetStreamClientError.JsSubNoMatchingStreamForSubject.instance();
            }
        } else {
            fnlStream = stream;
        }
        ConsumerConfiguration serverCC = null;
        String consumerName = userCC.getDurable();
        String inboxDeliver = userCC.getDeliverSubject();
        if (consumerName != null) {
            ConsumerInfo serverInfo = this.lookupConsumerInfo(fnlStream, consumerName);
            if (serverInfo != null) {
                ConsumerConfigurationComparer userCCC = new ConsumerConfigurationComparer(userCC);
                serverCC = serverInfo.getConsumerConfiguration();
                List<String> changes = userCCC.getChanges(serverCC);
                if (changes.size() > 0) {
                    throw NatsJetStreamClientError.JsSubExistingConsumerCannotBeModified.instance("Changed fields: " + changes.toString());
                }
                if (isPullMode) {
                    if (!Validator.nullOrEmpty(serverCC.getDeliverSubject())) {
                        throw NatsJetStreamClientError.JsSubConsumerAlreadyConfiguredAsPush.instance();
                    }
                } else if (Validator.nullOrEmpty(serverCC.getDeliverSubject())) {
                    throw NatsJetStreamClientError.JsSubConsumerAlreadyConfiguredAsPull.instance();
                }
                if (serverCC.getDeliverGroup() == null) {
                    if (qgroup != null) throw NatsJetStreamClientError.JsSubExistingConsumerNotQueue.instance();
                    if (serverInfo.isPushBound()) {
                        throw NatsJetStreamClientError.JsSubConsumerAlreadyBound.instance();
                    }
                } else {
                    if (qgroup == null) {
                        throw NatsJetStreamClientError.JsSubExistingConsumerIsQueue.instance();
                    }
                    if (!serverCC.getDeliverGroup().equals(qgroup)) {
                        throw NatsJetStreamClientError.JsSubExistingQueueDoesNotMatchRequestedQueue.instance();
                    }
                }
                if (Validator.nullOrEmpty(subject)) {
                    subject = userCC.getFilterSubject();
                } else if (!this.isFilterMatch(subject, serverCC.getFilterSubject(), fnlStream)) {
                    throw NatsJetStreamClientError.JsSubSubjectDoesNotMatchFilter.instance();
                }
                inboxDeliver = serverCC.getDeliverSubject();
            } else if (so.isBind()) {
                throw NatsJetStreamClientError.JsSubConsumerNotFoundRequiredInBind.instance();
            }
        }
        String string = fnlInboxDeliver = inboxDeliver == null ? this.conn.createInbox() : inboxDeliver;
        if (serverCC == null) {
            ConsumerConfiguration.Builder ccBuilder = ConsumerConfiguration.builder(userCC);
            if (!isPullMode) {
                ccBuilder.deliverSubject(fnlInboxDeliver);
            }
            if (userCC.getFilterSubject() == null) {
                ccBuilder.filterSubject(subject);
            }
            ccBuilder.deliverGroup(qgroup);
            settledServerCC = ccBuilder.build();
            settledConsumerName = null;
        } else {
            settledServerCC = serverCC;
            settledConsumerName = consumerName;
        }
        if (isPullMode) {
            MessageManager manager = this.PULL_MESSAGE_MANAGER_FACTORY.createPullMessageManager();
            NatsSubscriptionFactory factory = (sid, lSubject, lQgroup, lConn, lDispatcher) -> new NatsJetStreamPullSubscription(sid, lSubject, lConn, this, fnlStream, settledConsumerName, manager);
            sub = (NatsJetStreamSubscription)this.conn.createSubscription(fnlInboxDeliver, qgroup, null, factory);
        } else {
            MessageManager manager = this.PUSH_MESSAGE_MANAGER_FACTORY != null ? this.PUSH_MESSAGE_MANAGER_FACTORY.createPushMessageManager(this.conn, this, fnlStream, so, settledServerCC, qgroup != null, dispatcher) : (so.isOrdered() ? new OrderedManager(this.conn, this, fnlStream, so, settledServerCC, qgroup != null, dispatcher) : new PushMessageManager(this.conn, this, fnlStream, so, settledServerCC, qgroup != null, dispatcher));
            NatsSubscriptionFactory factory = (sid, lSubject, lQgroup, lConn, lDispatcher) -> {
                NatsJetStreamSubscription nsub = new NatsJetStreamSubscription(sid, lSubject, lQgroup, lConn, lDispatcher, this, fnlStream, settledConsumerName, manager);
                if (lDispatcher == null) {
                    nsub.setPendingLimits(so.getPendingMessageLimit(), so.getPendingByteLimit());
                }
                return nsub;
            };
            if (dispatcher == null) {
                sub = (NatsJetStreamSubscription)this.conn.createSubscription(fnlInboxDeliver, qgroup, null, factory);
            } else {
                AsyncMessageHandler handler = new AsyncMessageHandler(userHandler, isAutoAck, settledServerCC, manager);
                sub = (NatsJetStreamSubscription)dispatcher.subscribeImplJetStream(fnlInboxDeliver, qgroup, handler, factory);
            }
        }
        if (settledConsumerName != null) return sub;
        this._createConsumerUnsubscribeOnException(fnlStream, settledServerCC, sub);
        return sub;
    }

    private boolean isFilterMatch(String subscribeSubject, String filterSubject, String stream) throws IOException, JetStreamApiException {
        if (subscribeSubject.equals(filterSubject)) {
            return true;
        }
        if (Validator.nullOrEmpty(filterSubject) || filterSubject.equals(">")) {
            String streamSubject = this.lookupStreamSubject(stream);
            return subscribeSubject.equals(streamSubject);
        }
        return false;
    }

    private String lookupStreamSubject(String stream) throws IOException, JetStreamApiException {
        StreamInfo si = this._getStreamInfo(stream, null);
        List<String> streamSubjects = si.getConfiguration().getSubjects();
        return streamSubjects.size() == 1 ? streamSubjects.get(0) : null;
    }

    @Override
    public JetStreamSubscription subscribe(String subject) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        return this.createSubscription(subject, null, null, null, false, null, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        return this.createSubscription(subject, null, null, null, false, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, String queue, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        queue = Validator.emptyAsNull(Validator.validateQueueName(queue, false));
        return this.createSubscription(subject, queue, null, null, false, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, Dispatcher dispatcher, MessageHandler handler, boolean autoAck) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subject, null, (NatsDispatcher)dispatcher, handler, autoAck, null, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, Dispatcher dispatcher, MessageHandler handler, boolean autoAck, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subject, null, (NatsDispatcher)dispatcher, handler, autoAck, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, String queue, Dispatcher dispatcher, MessageHandler handler, boolean autoAck, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        queue = Validator.emptyAsNull(Validator.validateQueueName(queue, false));
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subject, queue, (NatsDispatcher)dispatcher, handler, autoAck, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, PullSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateNotNull(options, "Pull Subscribe Options");
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        return this.createSubscription(subject, null, null, null, false, null, options);
    }

    private boolean isSubjectRequired(SubscribeOptions options) {
        return options == null || !options.isBind();
    }

    ConsumerInfo lookupConsumerInfo(String stream, String consumer) throws IOException, JetStreamApiException {
        try {
            return this._getConsumerInfo(stream, consumer);
        }
        catch (JetStreamApiException e) {
            if (e.getApiErrorCode() == 10014 || e.getErrorCode() == 404 && e.getErrorDescription().contains("consumer")) {
                return null;
            }
            throw e;
        }
    }

    protected String lookupStreamBySubject(String subject) throws IOException, JetStreamApiException {
        List<String> list = this._getStreamNames(subject);
        return list.size() == 1 ? list.get(0) : null;
    }

    static class AsyncMessageHandler
    implements MessageHandler {
        MessageManager manager;
        List<MessageHandler> handlers = new ArrayList<MessageHandler>();

        public AsyncMessageHandler(MessageHandler userHandler, boolean isAutoAck, ConsumerConfiguration settledServerCC, MessageManager manager) {
            this.handlers.add(userHandler);
            if (isAutoAck && settledServerCC.getAckPolicy() != AckPolicy.None) {
                this.handlers.add(Message::ack);
            }
            this.manager = manager;
        }

        @Override
        public void onMessage(Message msg) throws InterruptedException {
            if (this.manager.manage(msg)) {
                return;
            }
            for (MessageHandler mh : this.handlers) {
                mh.onMessage(msg);
            }
        }
    }

    static class ConsumerConfigurationComparer
    extends ConsumerConfiguration {
        public ConsumerConfigurationComparer(ConsumerConfiguration cc) {
            super(cc);
        }

        public List<String> getChanges(ConsumerConfiguration serverCc) {
            ConsumerConfigurationComparer serverCcc = new ConsumerConfigurationComparer(serverCc);
            ArrayList<String> changes = new ArrayList<String>();
            if (this.deliverPolicy != null && this.deliverPolicy != serverCcc.getDeliverPolicy()) {
                changes.add("deliverPolicy");
            }
            if (this.ackPolicy != null && this.ackPolicy != serverCcc.getAckPolicy()) {
                changes.add("ackPolicy");
            }
            if (this.replayPolicy != null && this.replayPolicy != serverCcc.getReplayPolicy()) {
                changes.add("replayPolicy");
            }
            if (this.flowControl != null && this.flowControl.booleanValue() != serverCcc.isFlowControl()) {
                changes.add("flowControl");
            }
            if (this.headersOnly != null && this.headersOnly.booleanValue() != serverCcc.isHeadersOnly()) {
                changes.add("headersOnly");
            }
            if (this.memStorage != null && this.memStorage.booleanValue() != serverCcc.isMemStorage()) {
                changes.add("memStorage");
            }
            if (this.startSeq != null && !this.startSeq.equals(serverCcc.getStartSequence())) {
                changes.add("startSequence");
            }
            if (this.rateLimit != null && !this.rateLimit.equals(serverCcc.getStartSequence())) {
                changes.add("rateLimit");
            }
            if (this.maxDeliver != null && !this.maxDeliver.equals(serverCcc.getMaxDeliver())) {
                changes.add("maxDeliver");
            }
            if (this.maxAckPending != null && !this.maxAckPending.equals(serverCcc.getMaxAckPending())) {
                changes.add("maxAckPending");
            }
            if (this.maxPullWaiting != null && !this.maxPullWaiting.equals(serverCcc.getMaxPullWaiting())) {
                changes.add("maxPullWaiting");
            }
            if (this.maxBatch != null && !this.maxBatch.equals(serverCcc.getMaxBatch())) {
                changes.add("maxBatch");
            }
            if (this.maxBytes != null && !this.maxBytes.equals(serverCcc.getMaxBytes())) {
                changes.add("maxBytes");
            }
            if (this.ackWait != null && !this.ackWait.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.ackWait))) {
                changes.add("ackWait");
            }
            if (this.idleHeartbeat != null && !this.idleHeartbeat.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.idleHeartbeat))) {
                changes.add("idleHeartbeat");
            }
            if (this.maxExpires != null && !this.maxExpires.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.maxExpires))) {
                changes.add("maxExpires");
            }
            if (this.inactiveThreshold != null && !this.inactiveThreshold.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.inactiveThreshold))) {
                changes.add("inactiveThreshold");
            }
            if (this.startTime != null && !this.startTime.equals(serverCcc.startTime)) {
                changes.add("startTime");
            }
            if (this.filterSubject != null && !this.filterSubject.equals(serverCcc.filterSubject)) {
                changes.add("filterSubject");
            }
            if (this.description != null && !this.description.equals(serverCcc.description)) {
                changes.add("description");
            }
            if (this.sampleFrequency != null && !this.sampleFrequency.equals(serverCcc.sampleFrequency)) {
                changes.add("sampleFrequency");
            }
            if (this.deliverSubject != null && !this.deliverSubject.equals(serverCcc.deliverSubject)) {
                changes.add("deliverSubject");
            }
            if (this.deliverGroup != null && !this.deliverGroup.equals(serverCcc.deliverGroup)) {
                changes.add("deliverGroup");
            }
            if (!this.backoff.equals(serverCcc.backoff)) {
                changes.add("backoff");
            }
            if (this.numReplicas != null && !this.numReplicas.equals(serverCcc.numReplicas)) {
                changes.add("numReplicas");
            }
            return changes;
        }
    }

    static interface PullMessageManagerFactory {
        public MessageManager createPullMessageManager();
    }

    static interface PushMessageManagerFactory {
        public MessageManager createPushMessageManager(NatsConnection var1, NatsJetStream var2, String var3, SubscribeOptions var4, ConsumerConfiguration var5, boolean var6, NatsDispatcher var7);
    }
}

