/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Options;
import io.nats.client.impl.DataPort;
import io.nats.client.impl.NatsConnection;
import io.nats.client.support.WebSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketDataPort
implements DataPort {
    private NatsConnection connection;
    private String host;
    private int port;
    private Socket socket;
    private boolean isSecure = false;
    private InputStream in;
    private OutputStream out;

    @Override
    public void connect(String serverURI, NatsConnection conn, long timeoutNanos) throws IOException {
        try {
            this.connection = conn;
            Options options = this.connection.getOptions();
            long timeout = timeoutNanos / 1000000L;
            URI uri = options.createURIForServer(serverURI);
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.socket = options.getProxy() != null ? new Socket(options.getProxy()) : new Socket();
            this.socket.setTcpNoDelay(true);
            this.socket.setReceiveBufferSize(0x200000);
            this.socket.setSendBufferSize(0x200000);
            this.socket.connect(new InetSocketAddress(this.host, this.port), (int)timeout);
            if (SocketDataPort.isWebsocketScheme(uri.getScheme())) {
                if ("wss".equalsIgnoreCase(uri.getScheme())) {
                    this.upgradeToSecure();
                }
                try {
                    this.socket = new WebSocket(this.socket, this.host, options.getHttpRequestInterceptors());
                }
                catch (Exception ex) {
                    this.socket.close();
                    throw ex;
                }
            }
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void upgradeToSecure() throws IOException {
        Options options = this.connection.getOptions();
        SSLContext context = options.getSslContext();
        SSLSocketFactory factory = context.getSocketFactory();
        Duration timeout = options.getConnectionTimeout();
        SSLSocket sslSocket = (SSLSocket)factory.createSocket(this.socket, this.host, this.port, true);
        sslSocket.setUseClientMode(true);
        CompletableFuture waitForHandshake = new CompletableFuture();
        sslSocket.addHandshakeCompletedListener(evt -> waitForHandshake.complete(null));
        sslSocket.startHandshake();
        try {
            waitForHandshake.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Exception ex) {
            this.connection.handleCommunicationIssue(ex);
            return;
        }
        this.socket = sslSocket;
        this.in = sslSocket.getInputStream();
        this.out = sslSocket.getOutputStream();
        this.isSecure = true;
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        return this.in.read(dst, off, len);
    }

    @Override
    public void write(byte[] src, int toWrite) throws IOException {
        this.out.write(src, 0, toWrite);
    }

    @Override
    public void shutdownInput() throws IOException {
        if (!this.isSecure) {
            this.socket.shutdownInput();
        }
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    private static boolean isWebsocketScheme(String scheme) {
        return "ws".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme);
    }
}

