/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.service.EndpointResponse;
import io.nats.service.ServiceResponse;
import java.util.List;
import java.util.Objects;

public class SchemaResponse
extends ServiceResponse {
    public static final String TYPE = "io.nats.micro.v1.schema_response";
    private final String apiUrl;
    private final List<EndpointResponse> endpoints;

    public SchemaResponse(String id, String name, String version, String apiUrl, List<EndpointResponse> endpoints) {
        super(TYPE, id, name, version);
        this.apiUrl = apiUrl;
        this.endpoints = endpoints;
    }

    public SchemaResponse(byte[] jsonBytes) {
        this(SchemaResponse.parseMessage(jsonBytes));
    }

    private SchemaResponse(JsonValue jv) {
        super(TYPE, jv);
        this.apiUrl = JsonValueUtils.readString(jv, "api_url");
        this.endpoints = EndpointResponse.listOf(JsonValueUtils.readValue(jv, "endpoints"));
    }

    @Override
    protected void subToJson(StringBuilder sb) {
        JsonUtils.addField(sb, "api_url", this.apiUrl);
        JsonUtils.addJsons(sb, "endpoints", this.endpoints);
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public List<EndpointResponse> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaResponse that = (SchemaResponse)o;
        if (!Objects.equals(this.apiUrl, that.apiUrl)) {
            return false;
        }
        return Objects.equals(this.endpoints, that.endpoints);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.apiUrl != null ? this.apiUrl.hashCode() : 0);
        result = 31 * result + (this.endpoints != null ? this.endpoints.hashCode() : 0);
        return result;
    }
}

