/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.ObjectStoreConfiguration;
import io.nats.client.api.Placement;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamInfo;
import java.time.Duration;

public class ObjectStoreStatus {
    private final StreamInfo streamInfo;
    private final ObjectStoreConfiguration config;

    public ObjectStoreStatus(StreamInfo si) {
        this.streamInfo = si;
        this.config = new ObjectStoreConfiguration(this.streamInfo.getConfiguration());
    }

    public String getBucketName() {
        return this.config.getBucketName();
    }

    public String getDescription() {
        return this.config.getDescription();
    }

    public StreamInfo getBackingStreamInfo() {
        return this.streamInfo;
    }

    public ObjectStoreConfiguration getConfiguration() {
        return this.config;
    }

    public long getSize() {
        return this.streamInfo.getStreamState().getByteCount();
    }

    public boolean isSealed() {
        return this.config.getBackingConfig().getSealed();
    }

    public Duration getTtl() {
        return this.config.getTtl();
    }

    public StorageType getStorageType() {
        return this.config.getStorageType();
    }

    public int getReplicas() {
        return this.config.getReplicas();
    }

    public Placement getPlacement() {
        return this.config.getPlacement();
    }

    public String getBackingStore() {
        return "JetStream";
    }

    public String toString() {
        return "ObjectStoreStatus{name='" + this.getBucketName() + '\'' + ", description='" + this.getDescription() + '\'' + ", ttl=" + this.getTtl() + ", storageType=" + (Object)((Object)this.getStorageType()) + ", replicas=" + this.getReplicas() + ", isSealed=" + this.isSealed() + '}';
    }
}

