/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.util.Arrays;
import java.util.List;

public class ServerInfo {
    private final String serverId;
    private final String serverName;
    private final String version;
    private final String go;
    private final String host;
    private final int port;
    private final boolean headersSupported;
    private final boolean authRequired;
    private final boolean tlsRequired;
    private final long maxPayload;
    private final List<String> connectURLs;
    private final int protocolVersion;
    private final byte[] nonce;
    private final boolean lameDuckMode;
    private final boolean jetStream;
    private final int clientId;
    private final String clientIp;
    private final String cluster;

    public ServerInfo(String json) {
        JsonValue jv;
        if (json == null || json.length() < 6 || '{' != json.charAt(0) && '{' != json.charAt(5)) {
            throw new IllegalArgumentException("Invalid Server Info");
        }
        try {
            jv = JsonParser.parse(json, json.indexOf("{"));
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Invalid Server Info Json");
        }
        this.serverId = JsonValueUtils.readString(jv, "server_id");
        this.serverName = JsonValueUtils.readString(jv, "server_name");
        this.version = JsonValueUtils.readString(jv, "version");
        this.go = JsonValueUtils.readString(jv, "go");
        this.host = JsonValueUtils.readString(jv, "host");
        this.headersSupported = JsonValueUtils.readBoolean(jv, "headers");
        this.authRequired = JsonValueUtils.readBoolean(jv, "auth_required");
        this.nonce = JsonValueUtils.readBytes(jv, "nonce");
        this.tlsRequired = JsonValueUtils.readBoolean(jv, "tls_required");
        this.lameDuckMode = JsonValueUtils.readBoolean(jv, "ldm");
        this.jetStream = JsonValueUtils.readBoolean(jv, "jetstream");
        this.port = JsonValueUtils.readInteger(jv, "port", 0);
        this.protocolVersion = JsonValueUtils.readInteger(jv, "proto", 0);
        this.maxPayload = JsonValueUtils.readLong(jv, "max_payload", 0L);
        this.clientId = JsonValueUtils.readInteger(jv, "client_id", 0);
        this.clientIp = JsonValueUtils.readString(jv, "client_ip");
        this.cluster = JsonValueUtils.readString(jv, "cluster");
        this.connectURLs = JsonValueUtils.readStringListIgnoreEmpty(jv, "connect_urls");
    }

    public boolean isLameDuckMode() {
        return this.lameDuckMode;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGoVersion() {
        return this.go;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isHeadersSupported() {
        return this.headersSupported;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isTLSRequired() {
        return this.tlsRequired;
    }

    public long getMaxPayload() {
        return this.maxPayload;
    }

    public List<String> getConnectURLs() {
        return this.connectURLs;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public boolean isJetStreamAvailable() {
        return this.jetStream;
    }

    public int getClientId() {
        return this.clientId;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getCluster() {
        return this.cluster;
    }

    private String getComparableVersion(String vString) {
        try {
            String[] v = vString.replaceAll("v", "").replaceAll("-", ".").split("\\Q.\\E");
            return ServerInfo.padded(v[0]) + ServerInfo.padded(v[1]) + ServerInfo.padded(v[2]) + ServerInfo.normalExtra(vString);
        }
        catch (NumberFormatException nfe) {
            return "";
        }
    }

    private static String padded(String vcomp) {
        int x = Integer.parseInt(vcomp);
        if (x < 10) {
            return "000" + x;
        }
        if (x < 100) {
            return "00" + x;
        }
        if (x < 1000) {
            return "0" + x;
        }
        return "" + x;
    }

    private static String normalExtra(String vString) {
        int at = vString.indexOf("-");
        return at == -1 ? "~" : vString.substring(at).toLowerCase();
    }

    public boolean isNewerVersionThan(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) > 0;
    }

    public boolean isSameVersion(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) == 0;
    }

    public boolean isOlderThanVersion(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) < 0;
    }

    public boolean isSameOrOlderThanVersion(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) <= 0;
    }

    public boolean isSameOrNewerThanVersion(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) >= 0;
    }

    public String toString() {
        return "ServerInfo{serverId='" + this.serverId + '\'' + ", serverName='" + this.serverName + '\'' + ", version='" + this.version + '\'' + ", go='" + this.go + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", headersSupported=" + this.headersSupported + ", authRequired=" + this.authRequired + ", tlsRequired=" + this.tlsRequired + ", maxPayload=" + this.maxPayload + ", connectURLs=" + this.connectURLs + ", protocolVersion=" + this.protocolVersion + ", nonce=" + Arrays.toString(this.nonce) + ", lameDuckMode=" + this.lameDuckMode + ", jetStream=" + this.jetStream + ", clientId=" + this.clientId + ", clientIp='" + this.clientIp + '\'' + ", cluster='" + this.cluster + '\'' + '}';
    }
}

