/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.Error;
import io.nats.client.api.External;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;

abstract class SourceInfoBase {
    protected final String name;
    protected final long lag;
    protected final Duration active;
    protected final External external;
    protected final Error error;

    SourceInfoBase(JsonValue vSourceInfo) {
        this.name = JsonValueUtils.readString(vSourceInfo, "name");
        this.lag = JsonValueUtils.readLong(vSourceInfo, "lag", 0L);
        this.active = JsonValueUtils.readNanos(vSourceInfo, "active", Duration.ZERO);
        this.external = External.optionalInstance(JsonValueUtils.readValue(vSourceInfo, "external"));
        this.error = Error.optionalInstance(JsonValueUtils.readValue(vSourceInfo, "error"));
    }

    public String getName() {
        return this.name;
    }

    public long getLag() {
        return this.lag;
    }

    public Duration getActive() {
        return this.active;
    }

    public External getExternal() {
        return this.external;
    }

    public Error getError() {
        return this.error;
    }

    public String toString() {
        return "Mirror{name='" + this.getName() + '\'' + ", lag=" + this.getLag() + ", active=" + this.getActive() + ", " + JsonUtils.objectString("external", this.external) + ", " + JsonUtils.objectString("error", this.error) + '}';
    }
}

