/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStreamMetaData;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.PullStatus;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;

abstract class MessageManager {
    protected static final int THRESHOLD = 3;
    protected final NatsConnection conn;
    protected final boolean syncMode;
    protected NatsJetStreamSubscription sub;
    protected long lastStreamSeq;
    protected long internalConsumerSeq;
    protected final AtomicLong lastMsgReceived;
    protected boolean hb;
    protected long idleHeartbeatSetting;
    protected long alarmPeriodSetting;
    protected HeartbeatTimer heartbeatTimer;

    protected MessageManager(NatsConnection conn, boolean syncMode) {
        this.conn = conn;
        this.syncMode = syncMode;
        this.lastStreamSeq = 0L;
        this.internalConsumerSeq = 0L;
        this.lastMsgReceived = new AtomicLong(System.currentTimeMillis());
        this.hb = false;
        this.idleHeartbeatSetting = 0L;
        this.alarmPeriodSetting = 0L;
    }

    protected boolean isSyncMode() {
        return this.syncMode;
    }

    protected long getLastStreamSequence() {
        return this.lastStreamSeq;
    }

    protected long getInternalConsumerSequence() {
        return this.internalConsumerSeq;
    }

    protected long getLastMsgReceived() {
        return this.lastMsgReceived.get();
    }

    protected boolean isHb() {
        return this.hb;
    }

    protected long getIdleHeartbeatSetting() {
        return this.idleHeartbeatSetting;
    }

    protected long getAlarmPeriodSetting() {
        return this.alarmPeriodSetting;
    }

    protected void startup(NatsJetStreamSubscription sub) {
        this.sub = sub;
    }

    protected void shutdown() {
        this.shutdownHeartbeatTimer();
    }

    protected void startPullRequest(PullRequestOptions pullRequestOptions) {
    }

    protected PullStatus getPullStatus() {
        return null;
    }

    protected void messageReceived() {
        this.lastMsgReceived.set(System.currentTimeMillis());
    }

    protected Boolean beforeQueueProcessorImpl(NatsMessage msg) {
        return true;
    }

    protected abstract boolean manage(Message var1);

    protected void trackJsMessage(Message msg) {
        NatsJetStreamMetaData meta = msg.metaData();
        this.lastStreamSeq = meta.streamSequence();
        ++this.internalConsumerSeq;
    }

    protected void initIdleHeartbeat(Duration configIdleHeartbeat, long configMessageAlarmTime) {
        long l = this.idleHeartbeatSetting = configIdleHeartbeat == null ? 0L : configIdleHeartbeat.toMillis();
        if (this.idleHeartbeatSetting <= 0L) {
            this.alarmPeriodSetting = 0L;
            this.hb = false;
        } else {
            this.alarmPeriodSetting = configMessageAlarmTime < this.idleHeartbeatSetting ? this.idleHeartbeatSetting * 3L : configMessageAlarmTime;
            this.hb = true;
        }
    }

    protected void initOrResetHeartbeatTimer() {
        if (this.heartbeatTimer == null) {
            this.heartbeatTimer = new HeartbeatTimer(this.alarmPeriodSetting);
        } else {
            this.heartbeatTimer.restart();
        }
    }

    protected void shutdownHeartbeatTimer() {
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.shutdown();
            this.heartbeatTimer = null;
        }
    }

    protected void handleHeartbeatError() {
        this.conn.executeCallback((c, el) -> el.heartbeatAlarm(c, this.sub, this.lastStreamSeq, this.internalConsumerSeq));
    }

    protected class HeartbeatTimer {
        protected Timer timer;
        protected boolean alive = true;
        protected long alarmPeriodSetting;

        protected HeartbeatTimer(long alarmPeriodSetting) {
            this.alarmPeriodSetting = alarmPeriodSetting;
            this.restart();
        }

        protected synchronized void restart() {
            this.cancel();
            if (this.alive) {
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new HeartbeatTimerTask(), this.alarmPeriodSetting);
            }
        }

        protected synchronized void shutdown() {
            this.alive = false;
            this.cancel();
        }

        private void cancel() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
                this.timer = null;
            }
        }

        protected class HeartbeatTimerTask
        extends TimerTask {
            protected HeartbeatTimerTask() {
            }

            @Override
            public void run() {
                long sinceLast = System.currentTimeMillis() - MessageManager.this.lastMsgReceived.get();
                if (sinceLast > HeartbeatTimer.this.alarmPeriodSetting) {
                    MessageManager.this.handleHeartbeatError();
                }
                HeartbeatTimer.this.restart();
            }
        }
    }
}

