/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.impl.AckType;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsJetStreamMetaData;
import io.nats.client.impl.NatsSubscription;
import io.nats.client.support.ByteArrayBuilder;
import io.nats.client.support.NatsConstants;
import io.nats.client.support.Status;
import io.nats.client.support.Validator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

public class NatsMessage
implements Message {
    protected static final String NOT_A_JET_STREAM_MESSAGE = "Message is not a JetStream message";
    protected String subject;
    protected String replyTo;
    protected byte[] data;
    protected boolean utf8mode;
    protected Headers headers;
    protected String sid;
    protected int controlLineLength;
    protected ByteArrayBuilder protocolBab;
    protected int sizeInBytes = -1;
    protected int headerLen = 0;
    protected int dataLen;
    protected NatsSubscription subscription;
    NatsMessage next;
    protected AckType lastAck;

    protected NatsMessage() {
        this((byte[])null);
    }

    protected NatsMessage(byte[] data) {
        this.data = data == null ? NatsConstants.EMPTY_BODY : data;
        this.dataLen = this.data.length;
    }

    @Deprecated
    public NatsMessage(String subject, String replyTo, byte[] data, boolean utf8mode) {
        this(subject, replyTo, null, data);
        this.utf8mode = utf8mode;
    }

    @Deprecated
    public NatsMessage(String subject, String replyTo, Headers headers, byte[] data, boolean utf8mode) {
        this(subject, replyTo, headers, data);
        this.utf8mode = utf8mode;
    }

    public NatsMessage(String subject, String replyTo, byte[] data) {
        this(subject, replyTo, null, data);
    }

    public NatsMessage(String subject, String replyTo, Headers headers, byte[] data) {
        this(data);
        this.subject = Validator.validateSubject(subject, true);
        this.replyTo = Validator.validateReplyTo(replyTo, false);
        this.headers = headers;
        this.utf8mode = false;
        this.finishConstruct();
    }

    public NatsMessage(Message message) {
        this(message.getData());
        this.subject = message.getSubject();
        this.replyTo = message.getReplyTo();
        this.headers = message.getHeaders();
        this.utf8mode = message.isUtf8mode();
        this.finishConstruct();
    }

    protected void finishConstruct() {
        int replyToLen = this.replyTo == null ? 0 : this.replyTo.length();
        this.headerLen = this.headers != null && !this.headers.isEmpty() ? this.headers.serializedLength() : 0;
        int headerAndDataLen = this.headerLen + this.dataLen;
        ByteArrayBuilder bab = new ByteArrayBuilder(32 + this.subject.length() * 2 + replyToLen + headerAndDataLen);
        if (this.headerLen > 0) {
            bab.append(NatsConstants.HPUB_SP_BYTES, 0, NatsConstants.HPUB_SP_BYTES_LEN);
        } else {
            bab.append(NatsConstants.PUB_SP_BYTES, 0, NatsConstants.PUB_SP_BYTES_LEN);
        }
        bab.append(this.subject.getBytes(StandardCharsets.UTF_8)).append((byte)32);
        if (replyToLen > 0) {
            bab.append(this.replyTo.getBytes(StandardCharsets.UTF_8)).append((byte)32);
        }
        if (this.headerLen > 0) {
            bab.append(Integer.toString(this.headerLen).getBytes(StandardCharsets.US_ASCII)).append((byte)32);
        }
        bab.append(Integer.toString(headerAndDataLen).getBytes(StandardCharsets.US_ASCII));
        this.protocolBab = bab;
        this.controlLineLength = this.protocolBab.length() + 2;
        this.sizeInBytes = this.controlLineLength + headerAndDataLen + 2;
    }

    long getSizeInBytes() {
        return this.sizeInBytes;
    }

    boolean isProtocol() {
        return false;
    }

    byte[] getProtocolBytes() {
        return this.protocolBab.toByteArray();
    }

    int getControlLineLength() {
        return this.controlLineLength;
    }

    Headers getOrCreateHeaders() {
        if (this.headers == null) {
            this.headers = new Headers();
        }
        return this.headers;
    }

    void setSubscription(NatsSubscription sub) {
        this.subscription = sub;
    }

    NatsSubscription getNatsSubscription() {
        return this.subscription;
    }

    @Override
    public String getSID() {
        return this.sid;
    }

    @Override
    public Connection getConnection() {
        return this.subscription == null ? null : this.subscription.connection;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getReplyTo() {
        return this.replyTo;
    }

    int copyNotEmptyHeaders(int destPosition, byte[] dest) {
        if (this.headers != null && !this.headers.isEmpty()) {
            return this.headers.serializeToArray(destPosition, dest);
        }
        return 0;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isStatusMessage() {
        return false;
    }

    @Override
    public Status getStatus() {
        return null;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public boolean isUtf8mode() {
        return this.utf8mode;
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public AckType lastAck() {
        return this.lastAck;
    }

    @Override
    public void ack() {
    }

    @Override
    public void ackSync(Duration d) throws InterruptedException, TimeoutException {
    }

    @Override
    public void nak() {
    }

    @Override
    public void nakWithDelay(Duration nakDelay) {
    }

    @Override
    public void nakWithDelay(long nakDelayMillis) {
    }

    @Override
    public void inProgress() {
    }

    @Override
    public void term() {
    }

    @Override
    public NatsJetStreamMetaData metaData() {
        throw new IllegalStateException(NOT_A_JET_STREAM_MESSAGE);
    }

    @Override
    public boolean isJetStream() {
        return false;
    }

    public String toString() {
        if (this.subject == null) {
            return "NatsMessage | " + this.protocolBytesToString();
        }
        return "NatsMessage |" + this.subject + "|" + this.replyToString() + "|" + this.dataToString() + "|";
    }

    String toDetailString() {
        return "NatsMessage:\n  subject='" + this.subject + '\'' + "\n  replyTo='" + this.replyToString() + '\'' + "\n  data=" + this.dataToString() + "\n  utf8mode=" + this.utf8mode + "\n  headers=" + this.headersToString() + "\n  sid='" + this.sid + '\'' + "\n  protocolBytes=" + this.protocolBytesToString() + "\n  sizeInBytes=" + this.sizeInBytes + "\n  headerLen=" + this.headerLen + "\n  dataLen=" + this.dataLen + "\n  subscription=" + this.subscription + "\n  next=" + this.nextToString();
    }

    private String headersToString() {
        return this.hasHeaders() ? new String(this.headers.getSerialized(), StandardCharsets.US_ASCII).replace("\r", "+").replace("\n", "+") : "";
    }

    private String dataToString() {
        if (this.data.length == 0) {
            return "<no data>";
        }
        String s = new String(this.data, StandardCharsets.UTF_8);
        int at = s.indexOf("io.nats.jetstream.api");
        if (at == -1) {
            return s.length() > 27 ? s.substring(0, 27) + "..." : s;
        }
        int at2 = s.indexOf(34, at);
        return s.substring(at, at2);
    }

    private String replyToString() {
        return this.replyTo == null ? "<no reply>" : this.replyTo;
    }

    private String protocolBytesToString() {
        return this.protocolBab == null ? null : this.protocolBab.toString();
    }

    private String nextToString() {
        return this.next == null ? "No" : "Yes";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String subject;
        private String replyTo;
        private Headers headers;
        private byte[] data;
        private boolean utf8mode;

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder replyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder data(String data) {
            if (data != null) {
                this.data = data.getBytes(StandardCharsets.UTF_8);
            }
            return this;
        }

        public Builder data(String data, Charset charset) {
            this.data = data.getBytes(charset);
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        @Deprecated
        public Builder utf8mode(boolean utf8mode) {
            this.utf8mode = utf8mode;
            return this;
        }

        public NatsMessage build() {
            return new NatsMessage(this.subject, this.replyTo, this.headers, this.data, this.utf8mode);
        }
    }
}

