/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.PushMessageManager;
import io.nats.client.support.Status;
import java.util.concurrent.atomic.AtomicReference;

class OrderedMessageManager
extends PushMessageManager {
    private long expectedExternalConsumerSeq = 1L;
    private final AtomicReference<String> targetSid = new AtomicReference();

    protected OrderedMessageManager(NatsConnection conn, NatsJetStream js, String stream, SubscribeOptions so, ConsumerConfiguration serverCC, boolean queueMode, boolean syncMode) {
        super(conn, js, stream, so, serverCC, queueMode, syncMode);
    }

    @Override
    protected void startup(NatsJetStreamSubscription sub) {
        this.targetSid.set(sub.getSID());
        super.startup(sub);
    }

    @Override
    protected boolean manage(Message msg) {
        if (!msg.getSID().equals(this.targetSid.get())) {
            return true;
        }
        Status status = msg.getStatus();
        if (status == null) {
            long receivedConsumerSeq = msg.metaData().consumerSequence();
            if (this.expectedExternalConsumerSeq != receivedConsumerSeq) {
                this.handleErrorCondition();
                return true;
            }
            this.trackJsMessage(msg);
            ++this.expectedExternalConsumerSeq;
            return false;
        }
        super.manageStatus(msg);
        return true;
    }

    private void handleErrorCondition() {
        block2: {
            try {
                this.targetSid.set(null);
                this.expectedExternalConsumerSeq = 1L;
                this.shutdown();
                String newDeliverSubject = this.sub.connection.createInbox();
                this.sub.reSubscribe(newDeliverSubject);
                this.targetSid.set(this.sub.getSID());
                ConsumerConfiguration userCC = ConsumerConfiguration.builder(this.originalCc).deliverPolicy(DeliverPolicy.ByStartSequence).deliverSubject(newDeliverSubject).startSequence(Math.max(1L, this.lastStreamSeq + 1L)).startTime(null).build();
                this.js._createConsumerUnsubscribeOnException(this.stream, userCC, this.sub);
                this.startup(this.sub);
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Ordered subscription fatal error.", e);
                this.js.conn.processException(ise);
                if (!this.syncMode) break block2;
                throw ise;
            }
        }
    }
}

