/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.Token;
import java.util.HashMap;
import java.util.Map;

public class Status {
    public static final String FLOW_CONTROL_TEXT = "FlowControl Request";
    public static final String HEARTBEAT_TEXT = "Idle Heartbeat";
    public static final String NO_RESPONDERS_TEXT = "No Responders Available For Request";
    public static final int FLOW_OR_HEARTBEAT_STATUS_CODE = 100;
    public static final int NO_RESPONDERS_CODE = 503;
    public static final int BAD_REQUEST_CODE = 400;
    public static final int NOT_FOUND_CODE = 404;
    public static final int REQUEST_TIMEOUT_CODE = 408;
    public static final int CONFLICT_CODE = 409;
    private final int code;
    private final String message;
    private static final Map<Integer, String> CODE_TO_TEXT = new HashMap<Integer, String>();

    public Status(int code, String message) {
        this.code = code;
        this.message = message == null ? this.makeMessage(code) : message;
    }

    public Status(Token codeToken, Token messageToken) {
        this(Status.extractCode(codeToken), Status.extractMessage(messageToken));
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    private static String extractMessage(Token messageToken) {
        return messageToken.hasValue() ? messageToken.getValue() : null;
    }

    private static int extractCode(Token codeToken) {
        try {
            return Integer.parseInt(codeToken.getValue());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid header status code");
        }
    }

    private String makeMessage(int code) {
        String message = CODE_TO_TEXT.get(code);
        return message == null ? "Server Status Message: " + code : message;
    }

    public String toString() {
        return "Status{code=" + this.code + ", message='" + this.message + '\'' + '}';
    }

    public boolean isFlowControl() {
        return this.code == 100 && this.message.equals(FLOW_CONTROL_TEXT);
    }

    public boolean isHeartbeat() {
        return this.code == 100 && this.message.equals(HEARTBEAT_TEXT);
    }

    public boolean isNoResponders() {
        return this.code == 503 && this.message.equals(NO_RESPONDERS_TEXT);
    }

    static {
        CODE_TO_TEXT.put(503, NO_RESPONDERS_TEXT);
    }
}

