/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.util.Objects;

public abstract class ServiceResponse
implements JsonSerializable {
    protected final String type;
    protected final String name;
    protected final String id;
    protected final String version;

    protected ServiceResponse(String type, String id, String name, String version) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.version = version;
    }

    protected ServiceResponse(String type, ServiceResponse template) {
        this.type = type;
        this.id = template.id;
        this.name = template.name;
        this.version = template.version;
    }

    protected ServiceResponse(String type, JsonValue jv) {
        String jvType = JsonValueUtils.readString(jv, "type");
        if (Validator.emptyAsNull(jvType) == null) {
            throw new IllegalArgumentException("Type cannot be null or empty.");
        }
        if (!type.equals(jvType)) {
            throw new IllegalArgumentException("Invalid type for " + this.getClass().getSimpleName() + ". Expecting: " + type + ". Received " + jvType);
        }
        this.type = type;
        this.id = Validator.required(JsonValueUtils.readString(jv, "id"), "Id");
        this.name = Validator.required(JsonValueUtils.readString(jv, "name"), "Name");
        this.version = Validator.required(JsonValueUtils.readString(jv, "version"), "Version");
    }

    protected static JsonValue parseMessage(byte[] bytes) {
        try {
            return JsonParser.parse(bytes);
        }
        catch (JsonParseException e) {
            return JsonValue.EMPTY_MAP;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    protected void subToJson(StringBuilder sb) {
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "id", this.id);
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "version", this.version);
        this.subToJson(sb);
        JsonUtils.addField(sb, "type", this.type);
        return JsonUtils.endJson(sb).toString();
    }

    public String toString() {
        return JsonUtils.toKey(this.getClass()) + this.toJson();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceResponse that = (ServiceResponse)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

