/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.BaseConsumeOptions;

public class FetchConsumeOptions
extends BaseConsumeOptions {
    public static FetchConsumeOptions DEFAULT_FETCH_OPTIONS = FetchConsumeOptions.builder().build();

    private FetchConsumeOptions(Builder b) {
        super(b);
    }

    public int getMaxMessages() {
        return this.messages;
    }

    public long getMaxBytes() {
        return this.bytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseConsumeOptions.Builder<Builder, FetchConsumeOptions> {
        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder maxMessages(int maxMessages) {
            this.messages(maxMessages);
            return (Builder)this.bytes(-1L);
        }

        public Builder maxBytes(long maxBytes) {
            return (Builder)super.bytes(maxBytes);
        }

        public Builder max(int maxBytes, int maxMessages) {
            this.messages(maxMessages);
            return (Builder)this.bytes(maxBytes);
        }

        @Override
        public FetchConsumeOptions build() {
            return new FetchConsumeOptions(this);
        }
    }
}

