/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.DiscardPolicy;
import io.nats.client.api.FeatureConfiguration;
import io.nats.client.api.Placement;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.support.NatsObjectStoreUtil;
import io.nats.client.support.Validator;
import java.time.Duration;

public class ObjectStoreConfiguration
extends FeatureConfiguration {
    ObjectStoreConfiguration(StreamConfiguration sc) {
        super(sc, NatsObjectStoreUtil.extractBucketName(sc.getName()));
    }

    public long getMaxBucketSize() {
        return this.sc.getMaxBytes();
    }

    public String toString() {
        return "ObjectStoreConfiguration{name='" + this.bucketName + '\'' + ", description='" + this.getDescription() + '\'' + ", maxBucketSize=" + this.getMaxBucketSize() + ", ttl=" + this.getTtl() + ", storageType=" + (Object)((Object)this.getStorageType()) + ", replicas=" + this.getReplicas() + ", placement=" + this.getPlacement() + '}';
    }

    public static Builder builder() {
        return new Builder((ObjectStoreConfiguration)null);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(ObjectStoreConfiguration osc) {
        return new Builder(osc);
    }

    public static class Builder {
        String name;
        StreamConfiguration.Builder scBuilder;

        public Builder() {
            this((ObjectStoreConfiguration)null);
        }

        public Builder(String name) {
            this((ObjectStoreConfiguration)null);
            this.name(name);
        }

        public Builder(ObjectStoreConfiguration osc) {
            if (osc == null) {
                this.scBuilder = new StreamConfiguration.Builder();
                this.replicas(1);
            } else {
                this.scBuilder = new StreamConfiguration.Builder(osc.sc);
                this.name = NatsObjectStoreUtil.extractBucketName(osc.sc.getName());
            }
        }

        public Builder name(String name) {
            this.name = Validator.validateBucketName(name, true);
            return this;
        }

        public Builder description(String description) {
            this.scBuilder.description(description);
            return this;
        }

        public Builder maxBucketSize(long maxBucketSize) {
            this.scBuilder.maxBytes(Validator.validateMaxBucketBytes(maxBucketSize));
            return this;
        }

        public Builder ttl(Duration ttl) {
            this.scBuilder.maxAge(ttl);
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.scBuilder.storageType(storageType);
            return this;
        }

        public Builder replicas(int replicas) {
            this.scBuilder.replicas(replicas);
            return this;
        }

        public Builder placement(Placement placement) {
            this.scBuilder.placement(placement);
            return this;
        }

        public ObjectStoreConfiguration build() {
            this.name = Validator.required(this.name, "name");
            this.scBuilder.name(NatsObjectStoreUtil.toStreamName(this.name)).subjects(NatsObjectStoreUtil.toMetaStreamSubject(this.name), NatsObjectStoreUtil.toChunkStreamSubject(this.name)).allowRollup(true).allowDirect(true).discardPolicy(DiscardPolicy.New);
            return new ObjectStoreConfiguration(this.scBuilder.build());
        }
    }
}

