/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.util.List;
import java.util.Objects;

public class SubjectTransform
implements JsonSerializable {
    private final String source;
    private final String destination;

    static SubjectTransform optionalInstance(JsonValue vSubjectTransform) {
        return vSubjectTransform == null ? null : new SubjectTransform(vSubjectTransform);
    }

    static List<SubjectTransform> optionalListOf(JsonValue vSubjectTransforms) {
        return JsonValueUtils.optionalListOf(vSubjectTransforms, SubjectTransform::new);
    }

    SubjectTransform(JsonValue vSubjectTransform) {
        this.source = JsonValueUtils.readString(vSubjectTransform, "src");
        this.destination = JsonValueUtils.readString(vSubjectTransform, "dest");
    }

    public SubjectTransform(String source, String destination) {
        this.source = source;
        this.destination = destination;
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.destination;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "src", this.source);
        JsonUtils.addField(sb, "dest", this.destination);
        return JsonUtils.endJson(sb).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectTransform that = (SubjectTransform)o;
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.destination, that.destination);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String source;
        private String destination;

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public SubjectTransform build() {
            return new SubjectTransform(this.source, this.destination);
        }
    }
}

