/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.SubscribeOptions;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStreamMetaData;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.PullManagerObserver;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;

abstract class MessageManager {
    protected static final int THRESHOLD = 3;
    protected final Object stateChangeLock = new Object();
    protected final NatsConnection conn;
    protected final SubscribeOptions so;
    protected final boolean syncMode;
    protected NatsJetStreamSubscription sub;
    protected long lastStreamSeq;
    protected long lastConsumerSeq;
    protected long lastMsgReceived;
    protected boolean hb;
    protected long idleHeartbeatSetting;
    protected long alarmPeriodSetting;
    protected TimerTask heartbeatTimerTask;
    protected Timer heartbeatTimer;

    protected MessageManager(NatsConnection conn, SubscribeOptions so, boolean syncMode) {
        this.conn = conn;
        this.so = so;
        this.syncMode = syncMode;
        this.lastStreamSeq = 0L;
        this.lastConsumerSeq = 0L;
        this.hb = false;
        this.idleHeartbeatSetting = 0L;
        this.alarmPeriodSetting = 0L;
        this.lastMsgReceived = System.currentTimeMillis();
    }

    protected boolean isSyncMode() {
        return this.syncMode;
    }

    protected long getLastStreamSequence() {
        return this.lastStreamSeq;
    }

    protected long getLastConsumerSequence() {
        return this.lastConsumerSeq;
    }

    protected long getLastMsgReceived() {
        return this.lastMsgReceived;
    }

    protected boolean isHb() {
        return this.hb;
    }

    protected long getIdleHeartbeatSetting() {
        return this.idleHeartbeatSetting;
    }

    protected long getAlarmPeriodSetting() {
        return this.alarmPeriodSetting;
    }

    protected void startup(NatsJetStreamSubscription sub) {
        this.sub = sub;
    }

    protected void shutdown() {
        this.shutdownHeartbeatTimer();
    }

    protected void startPullRequest(String pullSubject, PullRequestOptions pullRequestOptions, boolean raiseStatusWarnings, PullManagerObserver pullManagerObserver) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceived() {
        Object object = this.stateChangeLock;
        synchronized (object) {
            this.lastMsgReceived = System.currentTimeMillis();
        }
    }

    protected Boolean beforeQueueProcessorImpl(NatsMessage msg) {
        return true;
    }

    protected abstract ManageResult manage(Message var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackJsMessage(Message msg) {
        Object object = this.stateChangeLock;
        synchronized (object) {
            NatsJetStreamMetaData meta = msg.metaData();
            this.lastStreamSeq = meta.streamSequence();
            ++this.lastConsumerSeq;
        }
    }

    protected void handleHeartbeatError() {
        this.conn.executeCallback((c, el) -> el.heartbeatAlarm(c, this.sub, this.lastStreamSeq, this.lastConsumerSeq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureIdleHeartbeat(Duration configIdleHeartbeat, long configMessageAlarmTime) {
        Object object = this.stateChangeLock;
        synchronized (object) {
            long l = this.idleHeartbeatSetting = configIdleHeartbeat == null ? 0L : configIdleHeartbeat.toMillis();
            if (this.idleHeartbeatSetting <= 0L) {
                this.alarmPeriodSetting = 0L;
                this.hb = false;
            } else {
                this.alarmPeriodSetting = configMessageAlarmTime < this.idleHeartbeatSetting ? this.idleHeartbeatSetting * 3L : configMessageAlarmTime;
                this.hb = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initOrResetHeartbeatTimer() {
        Object object = this.stateChangeLock;
        synchronized (object) {
            this.shutdownHeartbeatTimer();
            this.heartbeatTimer = new Timer();
            this.heartbeatTimerTask = new TimerTask(){

                @Override
                public void run() {
                    long sinceLast = System.currentTimeMillis() - MessageManager.this.lastMsgReceived;
                    if (sinceLast > MessageManager.this.alarmPeriodSetting) {
                        MessageManager.this.handleHeartbeatError();
                    }
                }
            };
            this.heartbeatTimer.schedule(this.heartbeatTimerTask, this.alarmPeriodSetting, this.alarmPeriodSetting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownHeartbeatTimer() {
        Object object = this.stateChangeLock;
        synchronized (object) {
            if (this.heartbeatTimer != null) {
                this.heartbeatTimer.cancel();
                this.heartbeatTimer = null;
            }
        }
    }

    public static enum ManageResult {
        MESSAGE,
        STATUS_HANDLED,
        STATUS_TERMINUS,
        STATUS_ERROR;

    }
}

