/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.PushMessageManager;
import java.util.concurrent.atomic.AtomicReference;

class OrderedMessageManager
extends PushMessageManager {
    protected long expectedExternalConsumerSeq = 1L;
    protected final AtomicReference<String> targetSid = new AtomicReference();

    protected OrderedMessageManager(NatsConnection conn, NatsJetStream js, String stream, SubscribeOptions so, ConsumerConfiguration originalCc, boolean queueMode, boolean syncMode) {
        super(conn, js, stream, so, originalCc, queueMode, syncMode);
    }

    @Override
    protected void startup(NatsJetStreamSubscription sub) {
        super.startup(sub);
        this.targetSid.set(sub.getSID());
    }

    @Override
    protected MessageManager.ManageResult manage(Message msg) {
        if (!msg.getSID().equals(this.targetSid.get())) {
            return MessageManager.ManageResult.STATUS_HANDLED;
        }
        if (msg.isJetStream()) {
            long receivedConsumerSeq = msg.metaData().consumerSequence();
            if (this.expectedExternalConsumerSeq != receivedConsumerSeq) {
                this.handleErrorCondition();
                return MessageManager.ManageResult.STATUS_HANDLED;
            }
            this.trackJsMessage(msg);
            ++this.expectedExternalConsumerSeq;
            return MessageManager.ManageResult.MESSAGE;
        }
        return this.manageStatus(msg);
    }

    private void handleErrorCondition() {
        block2: {
            try {
                this.targetSid.set(null);
                this.expectedExternalConsumerSeq = 1L;
                this.shutdown();
                String newDeliverSubject = this.sub.connection.createInbox();
                this.sub.reSubscribe(newDeliverSubject);
                this.targetSid.set(this.sub.getSID());
                ConsumerConfiguration userCC = this.js.nextOrderedConsumerConfiguration(this.originalCc, this.lastStreamSeq, newDeliverSubject);
                this.js._createConsumerUnsubscribeOnException(this.stream, userCC, this.sub);
                this.startup(this.sub);
            }
            catch (Exception e) {
                this.js.conn.processException(e);
                if (!this.syncMode) break block2;
                throw new RuntimeException("Ordered subscription fatal error.", e);
            }
        }
    }
}

