/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

public class EndpointStats
implements JsonSerializable {
    private final String name;
    private final String subject;
    private final long numRequests;
    private final long numErrors;
    private final long processingTime;
    private final long averageProcessingTime;
    private final String lastError;
    private final JsonValue data;
    private final ZonedDateTime started;

    static List<EndpointStats> listOf(JsonValue vEndpointStats) {
        return JsonValueUtils.listOf(vEndpointStats, EndpointStats::new);
    }

    EndpointStats(String name, String subject, long numRequests, long numErrors, long processingTime, String lastError, JsonValue data, ZonedDateTime started) {
        this.name = name;
        this.subject = subject;
        this.numRequests = numRequests;
        this.numErrors = numErrors;
        this.processingTime = processingTime;
        this.averageProcessingTime = numRequests < 1L ? 0L : processingTime / numRequests;
        this.lastError = lastError;
        this.data = data;
        this.started = started;
    }

    EndpointStats(JsonValue vEndpointStats) {
        this.name = JsonValueUtils.readString(vEndpointStats, "name");
        this.subject = JsonValueUtils.readString(vEndpointStats, "subject");
        this.numRequests = JsonValueUtils.readLong(vEndpointStats, "num_requests", 0L);
        this.numErrors = JsonValueUtils.readLong(vEndpointStats, "num_errors", 0L);
        this.processingTime = JsonValueUtils.readLong(vEndpointStats, "processing_time", 0L);
        this.averageProcessingTime = JsonValueUtils.readLong(vEndpointStats, "average_processing_time", 0L);
        this.lastError = JsonValueUtils.readString(vEndpointStats, "last_error");
        this.data = JsonValueUtils.readValue(vEndpointStats, "data");
        this.started = JsonValueUtils.readDate(vEndpointStats, "started");
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "subject", this.subject);
        JsonUtils.addFieldWhenGtZero(sb, "num_requests", this.numRequests);
        JsonUtils.addFieldWhenGtZero(sb, "num_errors", this.numErrors);
        JsonUtils.addFieldWhenGtZero(sb, "processing_time", this.processingTime);
        JsonUtils.addFieldWhenGtZero(sb, "average_processing_time", this.averageProcessingTime);
        JsonUtils.addField(sb, "last_error", this.lastError);
        JsonUtils.addField(sb, "data", this.data);
        JsonUtils.addField(sb, "started", this.started);
        return JsonUtils.endJson(sb).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getSubject() {
        return this.subject;
    }

    public long getNumRequests() {
        return this.numRequests;
    }

    public long getNumErrors() {
        return this.numErrors;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getAverageProcessingTime() {
        return this.averageProcessingTime;
    }

    public String getLastError() {
        return this.lastError;
    }

    public JsonValue getData() {
        return this.data;
    }

    public String getDataAsJson() {
        return this.data == null ? null : this.data.toJson();
    }

    public ZonedDateTime getStarted() {
        return this.started;
    }

    public String toString() {
        return JsonUtils.toKey(this.getClass()) + this.toJson();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointStats that = (EndpointStats)o;
        if (this.numRequests != that.numRequests) {
            return false;
        }
        if (this.numErrors != that.numErrors) {
            return false;
        }
        if (this.processingTime != that.processingTime) {
            return false;
        }
        if (this.averageProcessingTime != that.averageProcessingTime) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.subject, that.subject)) {
            return false;
        }
        if (!Objects.equals(this.lastError, that.lastError)) {
            return false;
        }
        if (!Objects.equals(this.data, that.data)) {
            return false;
        }
        return Objects.equals(this.started, that.started);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 31 * result + (int)(this.numRequests ^ this.numRequests >>> 32);
        result = 31 * result + (int)(this.numErrors ^ this.numErrors >>> 32);
        result = 31 * result + (int)(this.processingTime ^ this.processingTime >>> 32);
        result = 31 * result + (int)(this.averageProcessingTime ^ this.averageProcessingTime >>> 32);
        result = 31 * result + (this.lastError != null ? this.lastError.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.started != null ? this.started.hashCode() : 0);
        return result;
    }
}

