/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Dispatcher;
import io.nats.client.support.JsonValue;
import io.nats.client.support.Validator;
import io.nats.service.Endpoint;
import io.nats.service.Group;
import io.nats.service.ServiceMessageHandler;
import java.util.Map;
import java.util.function.Supplier;

public class ServiceEndpoint {
    private final Group group;
    private final Endpoint endpoint;
    private final ServiceMessageHandler handler;
    private final Dispatcher dispatcher;
    private final Supplier<JsonValue> statsDataSupplier;

    private ServiceEndpoint(Builder b, Endpoint e) {
        this.group = b.group;
        this.endpoint = e;
        this.handler = b.handler;
        this.dispatcher = b.dispatcher;
        this.statsDataSupplier = b.statsDataSupplier;
    }

    ServiceEndpoint(Endpoint endpoint, ServiceMessageHandler handler, Dispatcher dispatcher) {
        this.group = null;
        this.endpoint = endpoint;
        this.handler = handler;
        this.dispatcher = dispatcher;
        this.statsDataSupplier = null;
    }

    public String getName() {
        return this.endpoint.getName();
    }

    public String getSubject() {
        return this.group == null ? this.endpoint.getSubject() : this.group.getSubject() + "." + this.endpoint.getSubject();
    }

    public String getGroupName() {
        return this.group == null ? null : this.group.getName();
    }

    public Map<String, String> getMetadata() {
        return this.endpoint.getMetadata();
    }

    protected Group getGroup() {
        return this.group;
    }

    protected Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected ServiceMessageHandler getHandler() {
        return this.handler;
    }

    protected Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    protected Supplier<JsonValue> getStatsDataSupplier() {
        return this.statsDataSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Group group;
        private ServiceMessageHandler handler;
        private Dispatcher dispatcher;
        private Supplier<JsonValue> statsDataSupplier;
        private Endpoint.Builder endpointBuilder = Endpoint.builder();

        public Builder group(Group group) {
            this.group = group;
            return this;
        }

        public Builder endpoint(Endpoint endpoint) {
            this.endpointBuilder = Endpoint.builder().endpoint(endpoint);
            return this;
        }

        public Builder endpointName(String name) {
            this.endpointBuilder.name(name);
            return this;
        }

        public Builder endpointSubject(String subject) {
            this.endpointBuilder.subject(subject);
            return this;
        }

        public Builder endpointMetadata(Map<String, String> metadata) {
            this.endpointBuilder.metadata(metadata);
            return this;
        }

        public Builder handler(ServiceMessageHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder dispatcher(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public Builder statsDataSupplier(Supplier<JsonValue> statsDataSupplier) {
            this.statsDataSupplier = statsDataSupplier;
            return this;
        }

        public ServiceEndpoint build() {
            Endpoint endpoint = this.endpointBuilder.build();
            Validator.required(this.handler, "Message Handler");
            return new ServiceEndpoint(this, endpoint);
        }
    }
}

