/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.Validator;
import java.time.Duration;

public abstract class SubscribeOptions {
    public static final long DEFAULT_ORDERED_HEARTBEAT = 5000L;
    protected final String stream;
    protected final boolean pull;
    protected final boolean bind;
    protected final boolean fastBind;
    protected final boolean ordered;
    protected final long messageAlarmTime;
    protected final ConsumerConfiguration consumerConfig;
    protected final long pendingMessageLimit;
    protected final long pendingByteLimit;
    protected final String name;

    protected SubscribeOptions(Builder builder, boolean isPull, String deliverSubject, String deliverGroup, long pendingMessageLimit, long pendingByteLimit) {
        this.pull = isPull;
        this.fastBind = builder.fastBind;
        this.bind = this.fastBind || builder.bind;
        this.ordered = builder.ordered;
        this.messageAlarmTime = builder.messageAlarmTime;
        if (this.ordered && this.bind) {
            throw NatsJetStreamClientError.JsSoOrderedNotAllowedWithBind.instance();
        }
        this.stream = Validator.validateStreamName(builder.stream, this.bind);
        String ccName = Validator.validateMustMatchIfBothSupplied(builder.name, builder.cc == null ? null : builder.cc.getName(), NatsJetStreamClientError.JsSoNameMismatch);
        ccName = Validator.validateConsumerName(ccName, false);
        String ccDurable = Validator.validateMustMatchIfBothSupplied(builder.durable, builder.cc == null ? null : builder.cc.getDurable(), NatsJetStreamClientError.JsSoDurableMismatch);
        ccDurable = Validator.validateDurable(ccDurable, false);
        this.name = Validator.validateMustMatchIfBothSupplied(ccName, ccDurable, NatsJetStreamClientError.JsConsumerNameDurableMismatch);
        if (this.bind && this.name == null) {
            throw NatsJetStreamClientError.JsSoNameOrDurableRequiredForBind.instance();
        }
        deliverGroup = Validator.validateMustMatchIfBothSupplied(deliverGroup, builder.cc == null ? null : builder.cc.getDeliverGroup(), NatsJetStreamClientError.JsSoDeliverGroupMismatch);
        deliverSubject = Validator.validateMustMatchIfBothSupplied(deliverSubject, builder.cc == null ? null : builder.cc.getDeliverSubject(), NatsJetStreamClientError.JsSoDeliverSubjectMismatch);
        this.pendingMessageLimit = pendingMessageLimit;
        this.pendingByteLimit = pendingByteLimit;
        if (this.ordered) {
            Validator.validateNotSupplied(deliverGroup, NatsJetStreamClientError.JsSoOrderedNotAllowedWithDeliverGroup);
            Validator.validateNotSupplied(ccDurable, NatsJetStreamClientError.JsSoOrderedNotAllowedWithDurable);
            Validator.validateNotSupplied(deliverSubject, NatsJetStreamClientError.JsSoOrderedNotAllowedWithDeliverSubject);
            long hb = 5000L;
            if (builder.cc != null) {
                Duration ccHb;
                if (builder.cc.ackPolicyWasSet() && builder.cc.getAckPolicy() != AckPolicy.None) {
                    throw NatsJetStreamClientError.JsSoOrderedRequiresAckPolicyNone.instance();
                }
                if (builder.cc.getMaxDeliver() > 1L) {
                    throw NatsJetStreamClientError.JsSoOrderedRequiresMaxDeliverOfOne.instance();
                }
                if (builder.cc.memStorageWasSet() && !builder.cc.isMemStorage()) {
                    throw NatsJetStreamClientError.JsSoOrderedMemStorageNotSuppliedOrTrue.instance();
                }
                if (builder.cc.numReplicasWasSet() && builder.cc.getNumReplicas() != 1) {
                    throw NatsJetStreamClientError.JsSoOrderedReplicasNotSuppliedOrOne.instance();
                }
                if (!this.pull && (ccHb = builder.cc.getIdleHeartbeat()) != null) {
                    hb = ccHb.toMillis();
                }
            }
            ConsumerConfiguration.Builder b = ConsumerConfiguration.builder(builder.cc).ackPolicy(AckPolicy.None).maxDeliver(1L).ackWait(Duration.ofHours(22L)).name(ccName).memStorage(true).numReplicas(1);
            if (!this.pull) {
                b.flowControl(hb);
            }
            this.consumerConfig = b.build();
        } else {
            this.consumerConfig = ConsumerConfiguration.builder(builder.cc).name(ccName).durable(ccDurable).deliverSubject(deliverSubject).deliverGroup(deliverGroup).build();
        }
    }

    public String getStream() {
        return this.stream;
    }

    public String getDurable() {
        return this.consumerConfig.getDurable();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPull() {
        return this.pull;
    }

    public boolean isBind() {
        return this.bind;
    }

    public boolean isFastBind() {
        return this.fastBind;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public long getMessageAlarmTime() {
        return this.messageAlarmTime;
    }

    public ConsumerConfiguration getConsumerConfiguration() {
        return this.consumerConfig;
    }

    public long getPendingMessageLimit() {
        return this.pendingMessageLimit;
    }

    public long getPendingByteLimit() {
        return this.pendingByteLimit;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{stream='" + this.stream + '\'' + "bind=" + this.bind + ", " + this.consumerConfig + '}';
    }

    protected static abstract class Builder<B, SO> {
        protected String stream;
        protected boolean bind;
        protected boolean fastBind;
        protected String durable;
        protected String name;
        protected ConsumerConfiguration cc;
        protected long messageAlarmTime = -1L;
        protected boolean ordered;

        protected Builder() {
        }

        protected abstract B getThis();

        public B stream(String stream) {
            this.stream = Validator.validateStreamName(stream, false);
            return this.getThis();
        }

        public B bind(boolean bind) {
            this.bind = bind;
            return this.getThis();
        }

        public B durable(String durable) {
            this.durable = Validator.validateDurable(durable, false);
            return this.getThis();
        }

        public B name(String name) {
            this.name = Validator.validateConsumerName(name, false);
            return this.getThis();
        }

        public B configuration(ConsumerConfiguration configuration) {
            this.cc = configuration;
            return this.getThis();
        }

        public B messageAlarmTime(long messageAlarmTime) {
            this.messageAlarmTime = messageAlarmTime;
            return this.getThis();
        }

        public abstract SO build();
    }
}

