/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.NatsConstants;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;

public class NatsUri {
    private static final int NO_PORT = -1;
    private static final String UNABLE_TO_PARSE = "Unable to parse URI string.";
    private static final String UNSUPPORTED_SCHEME = "Unsupported NATS URI scheme.";
    private static final String URI_E_ALLOW_TRY_PREFIXED = "Illegal character in scheme name at index";
    private static final Pattern IPV4_RE = Pattern.compile("(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])");
    private static final String COLON_SLASH_SLASH = "://";
    public static NatsUri DEFAULT_NATS_URI = new NatsUri();
    private final URI uri;
    private boolean isSecure;
    private boolean isWebsocket;
    private boolean hostIsIpAddress;

    public URI getUri() {
        return this.uri;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getUserInfo() {
        return this.uri.getUserInfo();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isWebsocket() {
        return this.isWebsocket;
    }

    public boolean hostIsIpAddress() {
        return this.hostIsIpAddress;
    }

    public NatsUri reHost(String newHost) throws URISyntaxException {
        String newUrl = this.uri.getRawUserInfo() == null ? this.uri.getScheme() + COLON_SLASH_SLASH + newHost + ":" + this.uri.getPort() : this.uri.getScheme() + COLON_SLASH_SLASH + this.uri.getRawUserInfo() + "@" + newHost + ":" + this.uri.getPort();
        return new NatsUri(newUrl, this.uri.getScheme());
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof NatsUri) {
            o = ((NatsUri)o).uri;
        }
        return this.uri.equals(o);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public NatsUri() {
        try {
            this.uri = new URI("nats://localhost:4222");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.postConstruct();
    }

    public NatsUri(URI uri) throws URISyntaxException {
        this(uri.toString(), null);
    }

    public NatsUri(String url) throws URISyntaxException {
        this(url, null);
    }

    public NatsUri(String url, String defaultScheme) throws URISyntaxException {
        String host;
        String prefix;
        if (defaultScheme == null) {
            prefix = "nats://";
        } else {
            prefix = defaultScheme.toLowerCase();
            if (!prefix.endsWith(COLON_SLASH_SLASH)) {
                prefix = prefix + COLON_SLASH_SLASH;
            }
        }
        Helper helper = this.parse(url, true, prefix);
        String scheme = helper.uri.getScheme();
        String path = helper.uri.getPath();
        if (scheme == null) {
            if (path != null) {
                helper = this.tryPrefixed(helper, prefix);
                scheme = helper.uri.getScheme();
                path = helper.uri.getPath();
            } else {
                throw new URISyntaxException(url, UNABLE_TO_PARSE);
            }
        }
        if ((host = helper.uri.getHost()) == null) {
            if (path == null) {
                helper = this.tryPrefixed(helper, prefix);
                scheme = helper.uri.getScheme();
                host = helper.uri.getHost();
            } else {
                throw new URISyntaxException(url, UNABLE_TO_PARSE);
            }
        }
        if (host == null) {
            throw new URISyntaxException(url, UNABLE_TO_PARSE);
        }
        String lower = scheme.toLowerCase();
        if (!NatsConstants.KNOWN_PROTOCOLS.contains(lower)) {
            throw new URISyntaxException(url, UNSUPPORTED_SCHEME);
        }
        if (!lower.equals(scheme)) {
            helper.url = helper.url.replace(scheme, lower);
        }
        this.uri = helper.uri.getPort() == -1 ? new URI(helper.url + ":" + 4222) : new URI(helper.url);
        this.postConstruct();
    }

    private void postConstruct() {
        String s = this.uri.getScheme().toLowerCase();
        this.isSecure = NatsConstants.SECURE_PROTOCOLS.contains(s);
        this.isWebsocket = NatsConstants.WSS_PROTOCOLS.contains(s);
        s = this.uri.getHost();
        this.hostIsIpAddress = IPV4_RE.matcher(s).matches() || s.startsWith("[") && s.endsWith("]");
    }

    private Helper tryPrefixed(Helper helper, String prefix) throws URISyntaxException {
        return this.parse(prefix + helper.url, false, prefix);
    }

    private Helper parse(String inUrl, boolean allowTryPrefixed, String prefix) throws URISyntaxException {
        Helper helper = new Helper();
        try {
            helper.url = inUrl.trim();
            helper.uri = new URI(helper.url);
            return helper;
        }
        catch (URISyntaxException e) {
            if (allowTryPrefixed && e.getMessage().contains(URI_E_ALLOW_TRY_PREFIXED)) {
                return this.tryPrefixed(helper, prefix);
            }
            throw e;
        }
    }

    public static String join(String delimiter, List<NatsUri> uris) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < uris.size(); ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(uris.get(i).toString());
        }
        return sb.toString();
    }

    private String equivalentComparable() {
        return this.uri.getHost().toLowerCase() + this.uri.getPort();
    }

    public boolean equivalent(NatsUri other) {
        return this.equivalentComparable().compareTo(other.equivalentComparable()) == 0;
    }

    static class Helper {
        String url;
        URI uri;

        Helper() {
        }
    }
}

