/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.AuthHandler;
import io.nats.client.impl.StringAuthHandler;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;

public class MemoryAuthHandler
implements AuthHandler {
    private final StringAuthHandler sah;

    public MemoryAuthHandler(byte[] input) {
        ByteBuffer bb = ByteBuffer.wrap(input);
        CharBuffer chars = StandardCharsets.UTF_8.decode(bb);
        char[] jwt = this.extract(chars, 1);
        char[] nkey = this.extract(chars, 2);
        this.sah = new StringAuthHandler(jwt, nkey);
    }

    private char[] extract(CharBuffer data, int headers) {
        char c;
        CharBuffer buff = CharBuffer.allocate(data.length());
        boolean skipLine = false;
        int headerCount = 0;
        int linePos = -1;
        while (data.length() > 0) {
            c = data.get();
            ++linePos;
            if (c == '\n' || c == '\r') {
                if (buff.position() > 0) break;
                skipLine = false;
                linePos = -1;
                continue;
            }
            if (skipLine || Character.isWhitespace(c)) continue;
            if (c == '-' && linePos == 0) {
                skipLine = true;
                ++headerCount;
                continue;
            }
            if (headerCount != headers) continue;
            buff.put(c);
        }
        if (buff.position() == 0 && headers == 1) {
            data.position(0);
            while (data.length() > 0) {
                c = data.get();
                if (c == '\n' || c == '\r' || Character.isWhitespace(c)) {
                    if (buff.position() <= 0) continue;
                    break;
                }
                buff.put(c);
            }
            buff.flip();
        } else {
            buff.flip();
        }
        char[] retVal = new char[buff.length()];
        buff.get(retVal);
        buff.clear();
        for (int i = 0; i < buff.capacity(); ++i) {
            buff.put('\u0000');
        }
        return retVal;
    }

    @Override
    public byte[] sign(byte[] nonce) {
        return this.sah.sign(nonce);
    }

    @Override
    public char[] getID() {
        return this.sah.getID();
    }

    @Override
    public char[] getJWT() {
        return this.sah.getJWT();
    }
}

