/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.MessageHandler;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.NatsSubscription;

class NatsDispatcherWithExecutor
extends NatsDispatcher {
    NatsDispatcherWithExecutor(NatsConnection conn, MessageHandler handler) {
        super(conn, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.running.get()) {
                NatsSubscription sub;
                NatsMessage msg = this.incoming.pop(this.waitForMessage);
                if (msg != null && (sub = msg.getNatsSubscription()) != null && sub.isActive()) {
                    MessageHandler handler = (MessageHandler)this.subscriptionHandlers.get(sub.getSID());
                    if (handler == null) {
                        handler = this.defaultHandler;
                    }
                    if (handler != null) {
                        sub.incrementDeliveredCount();
                        this.incrementDeliveredCount();
                        MessageHandler finalHandler = handler;
                        this.connection.getExecutor().execute(() -> {
                            try {
                                finalHandler.onMessage(msg);
                            }
                            catch (Exception exp) {
                                this.connection.processException(exp);
                            }
                            if (sub.reachedUnsubLimit()) {
                                this.connection.invalidate(sub);
                            }
                        });
                    }
                }
                if (!this.breakRunLoop()) continue;
                return;
            }
        }
        catch (InterruptedException exp) {
            if (this.running.get()) {
                this.connection.processException(exp);
            }
        }
        finally {
            this.running.set(false);
            this.thread = null;
        }
    }
}

