/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ConnectionListener;
import io.nats.client.ConsumerContext;
import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamOptions;
import io.nats.client.KeyValue;
import io.nats.client.KeyValueManagement;
import io.nats.client.KeyValueOptions;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.ObjectStore;
import io.nats.client.ObjectStoreManagement;
import io.nats.client.ObjectStoreOptions;
import io.nats.client.Options;
import io.nats.client.Statistics;
import io.nats.client.StreamContext;
import io.nats.client.Subscription;
import io.nats.client.api.ServerInfo;
import io.nats.client.impl.Headers;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;

public interface Connection
extends AutoCloseable {
    public void publish(String var1, byte[] var2);

    public void publish(String var1, Headers var2, byte[] var3);

    public void publish(String var1, String var2, byte[] var3);

    public void publish(String var1, String var2, Headers var3, byte[] var4);

    public void publish(Message var1);

    public CompletableFuture<Message> request(String var1, byte[] var2);

    public CompletableFuture<Message> request(String var1, Headers var2, byte[] var3);

    public CompletableFuture<Message> requestWithTimeout(String var1, byte[] var2, Duration var3);

    public CompletableFuture<Message> requestWithTimeout(String var1, Headers var2, byte[] var3, Duration var4);

    public CompletableFuture<Message> request(Message var1);

    public CompletableFuture<Message> requestWithTimeout(Message var1, Duration var2);

    public Message request(String var1, byte[] var2, Duration var3) throws InterruptedException;

    public Message request(String var1, Headers var2, byte[] var3, Duration var4) throws InterruptedException;

    public Message request(Message var1, Duration var2) throws InterruptedException;

    public Subscription subscribe(String var1);

    public Subscription subscribe(String var1, String var2);

    public Dispatcher createDispatcher(MessageHandler var1);

    public Dispatcher createDispatcher();

    public void closeDispatcher(Dispatcher var1);

    public void addConnectionListener(ConnectionListener var1);

    public void removeConnectionListener(ConnectionListener var1);

    public void flush(Duration var1) throws TimeoutException, InterruptedException;

    public CompletableFuture<Boolean> drain(Duration var1) throws TimeoutException, InterruptedException;

    @Override
    public void close() throws InterruptedException;

    public Status getStatus();

    public long getMaxPayload();

    public Collection<String> getServers();

    public Statistics getStatistics();

    public Options getOptions();

    public ServerInfo getServerInfo();

    public String getConnectedUrl();

    public InetAddress getClientInetAddress();

    public String getLastError();

    public void clearLastError();

    public String createInbox();

    public void flushBuffer() throws IOException;

    public void forceReconnect() throws IOException, InterruptedException;

    public Duration RTT() throws IOException;

    public StreamContext getStreamContext(String var1) throws IOException, JetStreamApiException;

    public StreamContext getStreamContext(String var1, JetStreamOptions var2) throws IOException, JetStreamApiException;

    public ConsumerContext getConsumerContext(String var1, String var2) throws IOException, JetStreamApiException;

    public ConsumerContext getConsumerContext(String var1, String var2, JetStreamOptions var3) throws IOException, JetStreamApiException;

    public JetStream jetStream() throws IOException;

    public JetStream jetStream(JetStreamOptions var1) throws IOException;

    public JetStreamManagement jetStreamManagement() throws IOException;

    public JetStreamManagement jetStreamManagement(JetStreamOptions var1) throws IOException;

    public KeyValue keyValue(String var1) throws IOException;

    public KeyValue keyValue(String var1, KeyValueOptions var2) throws IOException;

    public KeyValueManagement keyValueManagement() throws IOException;

    public KeyValueManagement keyValueManagement(KeyValueOptions var1) throws IOException;

    public ObjectStore objectStore(String var1) throws IOException;

    public ObjectStore objectStore(String var1, ObjectStoreOptions var2) throws IOException;

    public ObjectStoreManagement objectStoreManagement() throws IOException;

    public ObjectStoreManagement objectStoreManagement(ObjectStoreOptions var1) throws IOException;

    public static enum Status {
        DISCONNECTED,
        CONNECTED,
        CLOSED,
        RECONNECTING,
        CONNECTING;

    }
}

