/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.Encoding;
import io.nats.client.support.HttpRequest;
import io.nats.client.support.WebsocketInputStream;
import io.nats.client.support.WebsocketOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class WebSocket
extends Socket {
    private static final int MAX_LINE_LEN = 8192;
    private static final int MAX_HTTP_HEADERS = 100;
    private static final String WEBSOCKET_RESPONSE_LINE = "HTTP/1.1 101 Switching Protocols";
    private final Socket wrappedSocket;
    private final WebsocketInputStream in;
    private final WebsocketOutputStream out;
    private final ReentrantLock closeLock = new ReentrantLock();

    public WebSocket(Socket wrappedSocket, String host, List<Consumer<HttpRequest>> interceptors) throws IOException {
        this.wrappedSocket = wrappedSocket;
        WebSocket.handshake(wrappedSocket, host, interceptors);
        this.in = new WebsocketInputStream(wrappedSocket.getInputStream());
        this.out = new WebsocketOutputStream(wrappedSocket.getOutputStream(), true);
    }

    private static void handshake(Socket socket, String host, List<Consumer<HttpRequest>> interceptors) throws IOException {
        MessageDigest sha1;
        HashMap<String, String> headers;
        String key;
        block11: {
            String line;
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            HttpRequest request = new HttpRequest();
            byte[] keyBytes = new byte[16];
            new SecureRandom().nextBytes(keyBytes);
            key = Encoding.base64BasicEncodeToString(keyBytes);
            request.getHeaders().add("Host", host).add("Upgrade", "websocket").add("Connection", "Upgrade").add("Sec-WebSocket-Key", key).add("Sec-WebSocket-Protocol", "nats").add("Sec-WebSocket-Version", "13");
            for (Consumer<HttpRequest> interceptor : interceptors) {
                interceptor.accept(request);
            }
            out.write(request.toString().getBytes(StandardCharsets.UTF_8));
            byte[] buffer = new byte[8192];
            String responseLine = WebSocket.readLine(buffer, in);
            if (null == responseLine) {
                throw new IllegalStateException("Expected HTTP response line not to exceed 8192");
            }
            if (!responseLine.toLowerCase().startsWith(WEBSOCKET_RESPONSE_LINE.toLowerCase())) {
                throw new IllegalStateException("Expected HTTP/1.1 101 Switching Protocols, but got " + responseLine);
            }
            headers = new HashMap<String, String>();
            while (true) {
                if (null == (line = WebSocket.readLine(buffer, in))) {
                    throw new IllegalStateException("Expected HTTP header to not exceed 8192");
                }
                if ("".equals(line)) break block11;
                int colon = line.indexOf(58);
                if (colon < 0) break;
                if (headers.size() >= 100) {
                    throw new IllegalStateException("Exceeded max HTTP headers=100");
                }
                headers.put(line.substring(0, colon).trim().toLowerCase(), line.substring(colon + 1).trim());
            }
            throw new IllegalStateException("Expected HTTP header to contain ':', but got " + line);
        }
        if (!"websocket".equalsIgnoreCase((String)headers.get("upgrade"))) {
            throw new IllegalStateException("Expected HTTP `Upgrade: websocket` header");
        }
        if (!"upgrade".equalsIgnoreCase((String)headers.get("connection"))) {
            throw new IllegalStateException("Expected HTTP `Connection: Upgrade` header");
        }
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        sha1.update(key.getBytes(StandardCharsets.UTF_8));
        sha1.update("258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.UTF_8));
        String acceptKey = Encoding.base64BasicEncodeToString(sha1.digest());
        String gotAcceptKey = (String)headers.get("sec-websocket-accept");
        if (!acceptKey.equals(gotAcceptKey)) {
            throw new IllegalStateException("Expected HTTP `Sec-WebSocket-Accept: " + acceptKey + ", but got " + gotAcceptKey);
        }
    }

    private static String readLine(byte[] buffer, InputStream in) throws IOException {
        int offset = 0;
        int lastCh = -1;
        while (true) {
            int ch = in.read();
            switch (ch) {
                case -1: {
                    return new String(buffer, 0, offset, StandardCharsets.ISO_8859_1);
                }
                case 10: {
                    return new String(buffer, 0, 13 == lastCh ? offset - 1 : offset, StandardCharsets.ISO_8859_1);
                }
            }
            if (offset >= buffer.length) {
                return null;
            }
            buffer[offset++] = (byte)ch;
            lastCh = ch;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public void connect(SocketAddress addr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connect(SocketAddress addr, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(SocketAddress addr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.wrappedSocket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.wrappedSocket.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.wrappedSocket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.wrappedSocket.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.wrappedSocket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.wrappedSocket.getLocalSocketAddress();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.wrappedSocket.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.wrappedSocket.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.wrappedSocket.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.wrappedSocket.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.wrappedSocket.sendUrgentData(data);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.wrappedSocket.setOOBInline(on);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.wrappedSocket.getOOBInline();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.wrappedSocket.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.wrappedSocket.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.wrappedSocket.setSendBufferSize(size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.wrappedSocket.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.wrappedSocket.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.wrappedSocket.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.wrappedSocket.setKeepAlive(on);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.wrappedSocket.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.wrappedSocket.setTrafficClass(tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.wrappedSocket.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.wrappedSocket.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.wrappedSocket.getReuseAddress();
    }

    @Override
    public void close() throws IOException {
        this.closeLock.lock();
        try {
            this.wrappedSocket.close();
        }
        finally {
            this.closeLock.unlock();
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        this.wrappedSocket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.wrappedSocket.shutdownOutput();
    }

    @Override
    public boolean isConnected() {
        return this.wrappedSocket.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.wrappedSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.wrappedSocket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.wrappedSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.wrappedSocket.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.wrappedSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }
}

