/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.AuthHandler;
import io.nats.client.NKey;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

class FileAuthHandler
implements AuthHandler {
    private String jwtFile;
    private String nkeyFile;
    private String credsFile;

    FileAuthHandler(String creds) {
        this.credsFile = creds;
    }

    FileAuthHandler(String jwtFile, String nkeyFile) {
        this.jwtFile = jwtFile;
        this.nkeyFile = nkeyFile;
    }

    private char[] extract(CharBuffer data, int headers) {
        char c;
        CharBuffer buff = CharBuffer.allocate(data.length());
        boolean skipLine = false;
        int headerCount = 0;
        int linePos = -1;
        while (data.length() > 0) {
            c = data.get();
            ++linePos;
            if (c == '\n' || c == '\r') {
                if (buff.position() > 0) break;
                skipLine = false;
                linePos = -1;
                continue;
            }
            if (skipLine || Character.isWhitespace(c)) continue;
            if (c == '-' && linePos == 0) {
                skipLine = true;
                ++headerCount;
                continue;
            }
            if (skipLine || headerCount != headers) continue;
            buff.put(c);
        }
        if (buff.position() == 0 && headers == 1) {
            data.position(0);
            while (data.length() > 0) {
                c = data.get();
                if (c == '\n' || c == '\r' || Character.isWhitespace(c)) {
                    if (buff.position() <= 0) continue;
                    break;
                }
                buff.put(c);
            }
            buff.flip();
        } else {
            buff.flip();
        }
        char[] retVal = new char[buff.length()];
        buff.get(retVal);
        buff.clear();
        for (int i = 0; i < buff.capacity(); ++i) {
            buff.put('\u0000');
        }
        return retVal;
    }

    private char[] readKeyChars() throws IOException {
        char[] keyChars = null;
        if (this.credsFile != null) {
            int i;
            byte[] data = Files.readAllBytes(Paths.get(this.credsFile, new String[0]));
            ByteBuffer bb = ByteBuffer.wrap(data);
            CharBuffer chars = StandardCharsets.UTF_8.decode(bb);
            keyChars = this.extract(chars, 3);
            chars.clear();
            for (i = 0; i < chars.capacity(); ++i) {
                chars.put('\u0000');
            }
            for (i = 0; i < data.length; ++i) {
                data[i] = 0;
            }
        } else {
            int i;
            byte[] data = Files.readAllBytes(Paths.get(this.nkeyFile, new String[0]));
            ByteBuffer bb = ByteBuffer.wrap(data);
            CharBuffer chars = StandardCharsets.UTF_8.decode(bb);
            keyChars = this.extract(chars, 1);
            chars.clear();
            for (i = 0; i < chars.capacity(); ++i) {
                chars.put('\u0000');
            }
            for (i = 0; i < data.length; ++i) {
                data[i] = 0;
            }
        }
        return keyChars;
    }

    @Override
    public byte[] sign(byte[] nonce) {
        try {
            char[] keyChars = this.readKeyChars();
            NKey nkey = NKey.fromSeed(keyChars);
            byte[] sig = nkey.sign(nonce);
            nkey.clear();
            return sig;
        }
        catch (Exception exp) {
            throw new IllegalStateException("problem signing nonce", exp);
        }
    }

    @Override
    public char[] getID() {
        try {
            char[] keyChars = this.readKeyChars();
            NKey nkey = NKey.fromSeed(keyChars);
            char[] pubKey = nkey.getPublicKey();
            nkey.clear();
            return pubKey;
        }
        catch (Exception exp) {
            throw new IllegalStateException("problem getting public key", exp);
        }
    }

    @Override
    public char[] getJWT() {
        try {
            int i;
            char[] jwtChars = null;
            String fileToUse = this.jwtFile;
            if (this.credsFile != null) {
                fileToUse = this.credsFile;
            }
            if (fileToUse == null) {
                return null;
            }
            byte[] data = Files.readAllBytes(Paths.get(fileToUse, new String[0]));
            ByteBuffer bb = ByteBuffer.wrap(data);
            CharBuffer chars = StandardCharsets.UTF_8.decode(bb);
            jwtChars = this.extract(chars, 1);
            chars.clear();
            for (i = 0; i < chars.capacity(); ++i) {
                chars.put('\u0000');
            }
            bb.clear();
            for (i = 0; i < data.length; ++i) {
                data[i] = 0;
            }
            return jwtChars;
        }
        catch (Exception exp) {
            throw new IllegalStateException("problem reading jwt", exp);
        }
    }
}

