/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.JetStreamOptions;
import io.nats.client.api.External;
import io.nats.client.api.SubjectTransform;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class SourceBase
implements JsonSerializable {
    private final String name;
    private final long startSeq;
    private final ZonedDateTime startTime;
    private final String filterSubject;
    private final External external;
    private final List<SubjectTransform> subjectTransforms;

    SourceBase(JsonValue jv) {
        this.name = JsonValueUtils.readString(jv, "name");
        this.startSeq = JsonValueUtils.readLong(jv, "opt_start_seq", 0L);
        this.startTime = JsonValueUtils.readDate(jv, "opt_start_time");
        this.filterSubject = JsonValueUtils.readString(jv, "filter_subject");
        this.external = External.optionalInstance(JsonValueUtils.readValue(jv, "external"));
        this.subjectTransforms = SubjectTransform.optionalListOf(JsonValueUtils.readValue(jv, "subject_transforms"));
    }

    SourceBase(SourceBaseBuilder<?> b) {
        this.name = b.name;
        this.startSeq = b.startSeq;
        this.startTime = b.startTime;
        this.filterSubject = b.filterSubject;
        this.external = b.external;
        this.subjectTransforms = b.subjectTransforms;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addFieldWhenGreaterThan(sb, "opt_start_seq", this.startSeq, 0L);
        JsonUtils.addField(sb, "opt_start_time", this.startTime);
        JsonUtils.addField(sb, "filter_subject", this.filterSubject);
        JsonUtils.addField(sb, "external", this.external);
        JsonUtils.addJsons(sb, "subject_transforms", this.subjectTransforms);
        return JsonUtils.endJson(sb).toString();
    }

    public String getSourceName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public long getStartSeq() {
        return this.startSeq;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public String getFilterSubject() {
        return this.filterSubject;
    }

    public External getExternal() {
        return this.external;
    }

    public List<SubjectTransform> getSubjectTransforms() {
        return this.subjectTransforms;
    }

    public String toString() {
        return JsonUtils.toKey(this.getClass()) + this.toJson();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceBase that = (SourceBase)o;
        if (this.startSeq != that.startSeq) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        if (!Objects.equals(this.filterSubject, that.filterSubject)) {
            return false;
        }
        if (!Objects.equals(this.external, that.external)) {
            return false;
        }
        return Validator.consumerFilterSubjectsAreEquivalent(this.subjectTransforms, that.subjectTransforms);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (int)(this.startSeq ^ this.startSeq >>> 32);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.filterSubject != null ? this.filterSubject.hashCode() : 0);
        result = 31 * result + (this.external != null ? this.external.hashCode() : 0);
        result = 31 * result + (this.subjectTransforms != null ? this.subjectTransforms.hashCode() : 0);
        return result;
    }

    public static abstract class SourceBaseBuilder<T> {
        String name;
        long startSeq;
        ZonedDateTime startTime;
        String filterSubject;
        External external;
        List<SubjectTransform> subjectTransforms = new ArrayList<SubjectTransform>();

        abstract T getThis();

        public SourceBaseBuilder() {
        }

        public SourceBaseBuilder(SourceBase base) {
            this.name = base.name;
            this.startSeq = base.startSeq;
            this.startTime = base.startTime;
            this.filterSubject = base.filterSubject;
            this.external = base.external;
            this.subjectTransforms = base.getSubjectTransforms();
        }

        public T sourceName(String name) {
            this.name = name;
            return this.getThis();
        }

        public T name(String name) {
            this.name = name;
            return this.getThis();
        }

        public T startSeq(long startSeq) {
            this.startSeq = startSeq;
            return this.getThis();
        }

        public T startTime(ZonedDateTime startTime) {
            this.startTime = startTime;
            return this.getThis();
        }

        public T filterSubject(String filterSubject) {
            this.filterSubject = filterSubject;
            return this.getThis();
        }

        public T external(External external) {
            this.external = external;
            return this.getThis();
        }

        public T domain(String domain) {
            String prefix = JetStreamOptions.convertDomainToPrefix(domain);
            this.external = prefix == null ? null : External.builder().api(prefix).build();
            return this.getThis();
        }

        public T subjectTransforms(SubjectTransform ... subjectTransforms) {
            this.subjectTransforms = subjectTransforms == null ? null : Arrays.asList(subjectTransforms);
            return this.getThis();
        }

        public T subjectTransforms(List<SubjectTransform> subjectTransforms) {
            this.subjectTransforms = subjectTransforms;
            return this.getThis();
        }
    }
}

