/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MessageBatchGetRequest
implements JsonSerializable {
    private final int batch;
    private final int maxBytes;
    private final long sequence;
    private final ZonedDateTime startTime;
    private final String nextBySubject;
    private final List<String> multiLastFor;
    private final long upToSequence;
    private final ZonedDateTime upToTime;

    MessageBatchGetRequest(Builder b) {
        this.batch = b.batch;
        this.maxBytes = b.maxBytes;
        this.sequence = b.sequence;
        this.startTime = b.startTime;
        this.nextBySubject = b.nextBySubject;
        this.multiLastFor = b.multiLastFor;
        this.upToSequence = b.upToSequence;
        this.upToTime = b.upToTime;
    }

    public int getBatch() {
        return this.batch;
    }

    public int getMaxBytes() {
        return this.maxBytes;
    }

    public long getSequence() {
        return this.sequence;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public String getSubject() {
        return this.nextBySubject;
    }

    public List<String> getMultiLastForSubjects() {
        return this.multiLastFor;
    }

    public long getUpToSequence() {
        return this.upToSequence;
    }

    public ZonedDateTime getUpToTime() {
        return this.upToTime;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "batch", this.batch);
        JsonUtils.addField(sb, "max_bytes", this.maxBytes);
        JsonUtils.addField(sb, "seq", this.sequence);
        JsonUtils.addField(sb, "start_time", this.startTime);
        JsonUtils.addField(sb, "next_by_subj", this.nextBySubject);
        JsonUtils.addStrings(sb, "multi_last", this.multiLastFor);
        JsonUtils.addField(sb, "up_to_seq", this.upToSequence);
        JsonUtils.addField(sb, "up_to_time", this.upToTime);
        return JsonUtils.endJson(sb).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MessageBatchGetRequest req) {
        return req == null ? new Builder() : new Builder(req);
    }

    public static class Builder {
        private int batch = -1;
        private int maxBytes = -1;
        private long sequence = -1L;
        private ZonedDateTime startTime = null;
        private String nextBySubject = null;
        private List<String> multiLastFor = new ArrayList<String>();
        private long upToSequence = -1L;
        private ZonedDateTime upToTime = null;

        public Builder() {
        }

        public Builder(MessageBatchGetRequest req) {
            if (req != null) {
                this.batch = req.batch;
                this.maxBytes = req.maxBytes;
                this.sequence = req.sequence;
                this.startTime = req.startTime;
                this.nextBySubject = req.nextBySubject;
                this.multiLastFor = req.multiLastFor;
                this.upToSequence = req.upToSequence;
                this.upToTime = req.upToTime;
            }
        }

        public Builder batch(int batch) {
            Validator.validateGtZero(batch, "Request batch size");
            this.batch = batch;
            return this;
        }

        public Builder maxBytes(int maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        public Builder sequence(long sequence) {
            Validator.validateGtEqZero(sequence, "Sequence");
            this.sequence = sequence;
            return this;
        }

        public Builder startTime(ZonedDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder subject(String subject) {
            this.nextBySubject = subject;
            return this;
        }

        public Builder multiLastForSubjects(String ... subjects) {
            this.multiLastFor.clear();
            this.multiLastFor.addAll(Arrays.asList(subjects));
            return this;
        }

        public Builder multiLastForSubjects(Collection<String> subjects) {
            this.multiLastFor.clear();
            this.multiLastFor.addAll(subjects);
            return this;
        }

        public Builder upToSequence(long upToSequence) {
            Validator.validateGtZero(upToSequence, "Up to sequence");
            this.upToSequence = upToSequence;
            return this;
        }

        public Builder upToTime(ZonedDateTime upToTime) {
            this.upToTime = upToTime;
            return this;
        }

        public MessageBatchGetRequest build() {
            return new MessageBatchGetRequest(this);
        }
    }
}

