/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.KeyValueConfiguration;
import io.nats.client.api.Placement;
import io.nats.client.api.Republish;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamInfo;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;
import java.util.Map;

public class KeyValueStatus {
    private final StreamInfo streamInfo;
    private final KeyValueConfiguration config;

    public KeyValueStatus(StreamInfo si) {
        this.streamInfo = si;
        this.config = new KeyValueConfiguration(this.streamInfo.getConfiguration());
    }

    public String getBucketName() {
        return this.config.getBucketName();
    }

    public String getDescription() {
        return this.config.getDescription();
    }

    public StreamInfo getBackingStreamInfo() {
        return this.streamInfo;
    }

    public KeyValueConfiguration getConfiguration() {
        return this.config;
    }

    public long getEntryCount() {
        return this.streamInfo.getStreamState().getMsgCount();
    }

    public long getByteCount() {
        return this.streamInfo.getStreamState().getByteCount();
    }

    public long getMaxHistoryPerKey() {
        return this.config.getMaxHistoryPerKey();
    }

    public long getMaxBucketSize() {
        return this.config.getMaxBucketSize();
    }

    @Deprecated
    public long getMaxValueSize() {
        return this.config.getMaximumValueSize();
    }

    public int getMaximumValueSize() {
        return this.config.getMaximumValueSize();
    }

    public Duration getTtl() {
        return this.config.getTtl();
    }

    public StorageType getStorageType() {
        return this.config.getStorageType();
    }

    public int getReplicas() {
        return this.config.getReplicas();
    }

    public Placement getPlacement() {
        return this.config.getPlacement();
    }

    public Republish getRepublish() {
        return this.config.getRepublish();
    }

    public boolean isCompressed() {
        return this.config.isCompressed();
    }

    public Map<String, String> getMetadata() {
        return this.config.getMetadata();
    }

    public Duration getLimitMarkerTtl() {
        return this.streamInfo.getConfig().getSubjectDeleteMarkerTtl();
    }

    public String getBackingStore() {
        return "JetStream";
    }

    public String toString() {
        JsonValueUtils.MapBuilder mb = new JsonValueUtils.MapBuilder();
        mb.put("entryCount", this.getEntryCount());
        mb.put("byteCount", this.getByteCount());
        mb.put("config", this.config);
        return "KeyValueStatus" + mb.toJsonValue().toJson();
    }
}

