/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.ClusterInfo;
import io.nats.client.api.MirrorInfo;
import io.nats.client.api.SourceInfo;
import io.nats.client.api.StreamAlternate;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamState;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.ZonedDateTime;
import java.util.List;

public class StreamInfo
extends ApiResponse<StreamInfo> {
    private final ZonedDateTime createTime;
    private final StreamConfiguration config;
    private final StreamState streamState;
    private final ClusterInfo clusterInfo;
    private final MirrorInfo mirrorInfo;
    private final List<SourceInfo> sourceInfos;
    private final List<StreamAlternate> alternates;
    private final ZonedDateTime timestamp;

    public StreamInfo(Message msg) {
        this(JsonParser.parseUnchecked(msg.getData()));
    }

    public StreamInfo(JsonValue vStreamInfo) {
        super(vStreamInfo);
        this.createTime = JsonValueUtils.readDate(this.jv, "created");
        this.config = StreamConfiguration.instance(JsonValueUtils.readValue(this.jv, "config"));
        this.streamState = new StreamState(JsonValueUtils.readValue(this.jv, "state"));
        this.clusterInfo = ClusterInfo.optionalInstance(JsonValueUtils.readValue(this.jv, "cluster"));
        this.mirrorInfo = MirrorInfo.optionalInstance(JsonValueUtils.readValue(this.jv, "mirror"));
        this.sourceInfos = SourceInfo.optionalListOf(JsonValueUtils.readValue(this.jv, "sources"));
        this.alternates = StreamAlternate.optionalListOf(JsonValueUtils.readValue(this.jv, "alternates"));
        this.timestamp = JsonValueUtils.readDate(this.jv, "ts");
    }

    public StreamConfiguration getConfiguration() {
        return this.config;
    }

    public StreamState getStreamState() {
        return this.streamState;
    }

    public ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    public MirrorInfo getMirrorInfo() {
        return this.mirrorInfo;
    }

    public List<SourceInfo> getSourceInfos() {
        return this.sourceInfos;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public StreamConfiguration getConfig() {
        return this.config;
    }

    public List<StreamAlternate> getAlternates() {
        return this.alternates;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String toString() {
        return "StreamInfo " + this.jv;
    }
}

