/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.KeyValueConfiguration;
import io.nats.client.api.Placement;
import io.nats.client.api.Republish;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamInfo;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyValueStatus {
    private final StreamInfo streamInfo;
    private final KeyValueConfiguration config;

    public KeyValueStatus(StreamInfo si) {
        this.streamInfo = si;
        this.config = new KeyValueConfiguration(this.streamInfo.getConfiguration());
    }

    @NotNull
    public String getBucketName() {
        return this.config.getBucketName();
    }

    @Nullable
    public String getDescription() {
        return this.config.getDescription();
    }

    @NotNull
    public StreamInfo getBackingStreamInfo() {
        return this.streamInfo;
    }

    @NotNull
    public KeyValueConfiguration getConfiguration() {
        return this.config;
    }

    public long getEntryCount() {
        return this.streamInfo.getStreamState().getMsgCount();
    }

    public long getByteCount() {
        return this.streamInfo.getStreamState().getByteCount();
    }

    public long getMaxHistoryPerKey() {
        return this.config.getMaxHistoryPerKey();
    }

    public long getMaxBucketSize() {
        return this.config.getMaxBucketSize();
    }

    @Deprecated
    public long getMaxValueSize() {
        return this.config.getMaximumValueSize();
    }

    public int getMaximumValueSize() {
        return this.config.getMaximumValueSize();
    }

    @Nullable
    public Duration getTtl() {
        return this.config.getTtl();
    }

    @NotNull
    public StorageType getStorageType() {
        return this.config.getStorageType();
    }

    public int getReplicas() {
        return this.config.getReplicas();
    }

    @Nullable
    public Placement getPlacement() {
        return this.config.getPlacement();
    }

    @Nullable
    public Republish getRepublish() {
        return this.config.getRepublish();
    }

    public boolean isCompressed() {
        return this.config.isCompressed();
    }

    @Nullable
    public Map<String, String> getMetadata() {
        return this.config.getMetadata();
    }

    @Nullable
    public Duration getLimitMarkerTtl() {
        return this.streamInfo.getConfig().getSubjectDeleteMarkerTtl();
    }

    @NotNull
    public String getBackingStore() {
        return "JetStream";
    }

    public String toString() {
        JsonValueUtils.MapBuilder mb = new JsonValueUtils.MapBuilder();
        mb.put("entryCount", this.getEntryCount());
        mb.put("byteCount", this.getByteCount());
        mb.put("config", this.config);
        return "KeyValueStatus" + mb.toJsonValue().toJson();
    }
}

