/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.ObjectLink;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectMetaOptions
implements JsonSerializable {
    private final ObjectLink link;
    private final int chunkSize;

    private ObjectMetaOptions(Builder b) {
        this.link = b.link;
        this.chunkSize = b.chunkSize;
    }

    ObjectMetaOptions(JsonValue vOptions) {
        this.link = ObjectLink.optionalInstance(JsonValueUtils.readValue(vOptions, "link"));
        this.chunkSize = JsonValueUtils.readInteger(vOptions, "max_chunk_size", -1);
    }

    @Override
    @NotNull
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "link", this.link);
        JsonUtils.addField(sb, "max_chunk_size", this.chunkSize);
        return JsonUtils.endJson(sb).toString();
    }

    boolean hasData() {
        return this.link != null || this.chunkSize > 0;
    }

    @Nullable
    public ObjectLink getLink() {
        return this.link;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    static Builder builder() {
        return new Builder();
    }

    static Builder builder(ObjectMetaOptions om) {
        return new Builder(om);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMetaOptions options = (ObjectMetaOptions)o;
        if (this.chunkSize != options.chunkSize) {
            return false;
        }
        return this.link != null ? this.link.equals(options.link) : options.link == null;
    }

    public int hashCode() {
        int result = this.link != null ? this.link.hashCode() : 0;
        result = 31 * result + this.chunkSize;
        return result;
    }

    public String toString() {
        return "ObjectMetaOptions{link=" + this.link + ", chunkSize=" + this.chunkSize + '}';
    }

    public static class Builder {
        ObjectLink link;
        int chunkSize;

        public Builder() {
        }

        public Builder(ObjectMetaOptions om) {
            this.link = om.link;
            this.chunkSize = om.chunkSize;
        }

        public Builder link(ObjectLink link) {
            this.link = link;
            return this;
        }

        public Builder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public ObjectMetaOptions build() {
            return new ObjectMetaOptions(this);
        }
    }
}

