/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Placement
implements JsonSerializable {
    private final String cluster;
    private final List<String> tags;

    static Placement optionalInstance(JsonValue vPlacement) {
        return vPlacement == null ? null : new Placement(vPlacement);
    }

    Placement(JsonValue vPlacement) {
        this.cluster = JsonValueUtils.readStringEmptyAsNull(vPlacement, "cluster");
        this.tags = JsonValueUtils.readOptionalStringList(vPlacement, "tags");
    }

    public Placement(String cluster, List<String> tags) {
        this.cluster = cluster == null || cluster.isEmpty() ? null : cluster;
        this.tags = tags == null || tags.isEmpty() ? null : tags;
    }

    public boolean hasData() {
        return this.cluster != null || this.tags != null;
    }

    @Nullable
    public String getCluster() {
        return this.cluster;
    }

    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "Placement{cluster='" + this.cluster + '\'' + ", tags=" + this.tags + '}';
    }

    @Override
    @NotNull
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "cluster", this.cluster);
        JsonUtils.addStrings(sb, "tags", this.tags);
        return JsonUtils.endJson(sb).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String cluster;
        private List<String> tags;

        public Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder tags(String ... tags) {
            this.tags = Arrays.asList(tags);
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Placement build() {
            return new Placement(this.cluster, this.tags);
        }
    }
}

