/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ErrorListener;
import io.nats.client.Message;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.Status;

class PushMessageManager
extends MessageManager {
    protected final NatsJetStream js;
    protected final String stream;
    protected final ConsumerConfiguration initialCc;
    protected final boolean queueMode;
    protected final boolean fc;
    protected String lastFcSubject;

    protected PushMessageManager(NatsConnection conn, NatsJetStream js, String stream, SubscribeOptions so, ConsumerConfiguration initialCc, boolean queueMode, boolean syncMode) {
        super(conn, so, syncMode);
        this.js = js;
        this.stream = stream;
        this.initialCc = initialCc;
        this.queueMode = queueMode;
        if (queueMode) {
            this.fc = false;
        } else {
            this.configureIdleHeartbeat(initialCc.getIdleHeartbeat(), so.getMessageAlarmTime());
            this.fc = this.hb && initialCc.isFlowControl();
        }
    }

    protected boolean isQueueMode() {
        return this.queueMode;
    }

    protected boolean isFc() {
        return this.fc;
    }

    protected String getLastFcSubject() {
        return this.lastFcSubject;
    }

    @Override
    protected void startup(NatsJetStreamSubscription sub) {
        super.startup(sub);
        sub.setBeforeQueueProcessor(this::beforeQueueProcessorImpl);
        if (this.hb) {
            this.initOrResetHeartbeatTimer();
        }
    }

    @Override
    protected Boolean beforeQueueProcessorImpl(NatsMessage msg) {
        if (this.hb) {
            this.updateLastMessageReceived();
            Status status = msg.getStatus();
            if (status != null && status.isHeartbeat()) {
                return this.hasFcSubject(msg);
            }
        }
        return true;
    }

    protected boolean hasFcSubject(Message msg) {
        return msg.getHeaders() != null && msg.getHeaders().containsKey("Nats-Consumer-Stalled");
    }

    protected String extractFcSubject(Message msg) {
        return msg.getHeaders() == null ? null : msg.getHeaders().getFirst("Nats-Consumer-Stalled");
    }

    @Override
    protected MessageManager.ManageResult manage(Message msg) {
        if (msg.getStatus() == null) {
            this.trackJsMessage(msg);
            return MessageManager.ManageResult.MESSAGE;
        }
        return this.manageStatus(msg);
    }

    protected MessageManager.ManageResult manageStatus(Message msg) {
        Status status = msg.getStatus();
        if (this.fc) {
            String fcSubject;
            boolean isFcNotHb = status.isFlowControl();
            String string = fcSubject = isFcNotHb ? msg.getReplyTo() : this.extractFcSubject(msg);
            if (fcSubject != null) {
                this.processFlowControl(fcSubject, isFcNotHb ? ErrorListener.FlowControlSource.FLOW_CONTROL : ErrorListener.FlowControlSource.HEARTBEAT);
                return MessageManager.ManageResult.STATUS_HANDLED;
            }
        }
        this.conn.executeCallback((c, el) -> el.unhandledStatus(c, this.sub, status));
        return MessageManager.ManageResult.STATUS_ERROR;
    }

    private void processFlowControl(String fcSubject, ErrorListener.FlowControlSource source) {
        if (fcSubject != null && !fcSubject.equals(this.lastFcSubject)) {
            this.conn.publishInternal(fcSubject, null, null, null, false, false);
            this.lastFcSubject = fcSubject;
            this.conn.executeCallback((c, el) -> el.flowControlProcessed(c, this.sub, fcSubject, source));
        }
    }
}

