/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public abstract class DateTimeUtils {
    public static final ZoneId ZONE_ID_GMT = ZoneId.of("GMT");
    public static final ZonedDateTime DEFAULT_TIME = ZonedDateTime.of(1, 1, 1, 0, 0, 0, 0, ZONE_ID_GMT);
    public static final DateTimeFormatter RFC3339_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.nnnnnnnnn'Z'");
    private static final long NANO_FACTOR = 1000000000L;

    private DateTimeUtils() {
    }

    public static ZonedDateTime toGmt(ZonedDateTime zonedDateTime) {
        return zonedDateTime.withZoneSameInstant(ZONE_ID_GMT);
    }

    public static ZonedDateTime gmtNow() {
        return ZonedDateTime.now().withZoneSameInstant(ZONE_ID_GMT);
    }

    public static boolean equals(ZonedDateTime zdt1, ZonedDateTime zdt2) {
        if (zdt1 == zdt2) {
            return true;
        }
        if (zdt1 == null || zdt2 == null) {
            return false;
        }
        return zdt1.withZoneSameInstant(ZONE_ID_GMT).equals(zdt2.withZoneSameInstant(ZONE_ID_GMT));
    }

    public static String toRfc3339(ZonedDateTime zonedDateTime) {
        return RFC3339_FORMATTER.format(DateTimeUtils.toGmt(zonedDateTime));
    }

    public static ZonedDateTime parseDateTime(String dateTime) {
        return DateTimeUtils.parseDateTime(dateTime, DEFAULT_TIME);
    }

    public static ZonedDateTime parseDateTime(String dateTime, ZonedDateTime dflt) {
        try {
            return DateTimeUtils.toGmt(ZonedDateTime.parse(dateTime));
        }
        catch (DateTimeParseException s) {
            return dflt;
        }
    }

    public static ZonedDateTime parseDateTimeThrowParseError(String dateTime) {
        return DateTimeUtils.toGmt(ZonedDateTime.parse(dateTime));
    }

    public static ZonedDateTime parseDateTimeNanos(String timestampNanos) {
        return DateTimeUtils.parseDateTimeNanos(timestampNanos, ZoneId.systemDefault());
    }

    public static ZonedDateTime parseDateTimeNanos(String timestampNanos, ZoneId zoneId) {
        long ts = Long.parseLong(timestampNanos);
        long seconds = ts / 1000000000L;
        long nanos = ts % 1000000000L;
        Instant utcInstant = Instant.ofEpochSecond(seconds, nanos);
        OffsetDateTime utcOffsetDT = OffsetDateTime.ofInstant(utcInstant, ZoneOffset.UTC);
        return utcOffsetDT.atZoneSameInstant(zoneId);
    }

    public static ZonedDateTime fromNow(long millis) {
        return ZonedDateTime.ofInstant(Instant.now().plusMillis(millis), ZONE_ID_GMT);
    }

    public static ZonedDateTime fromNow(Duration dur) {
        return ZonedDateTime.ofInstant(Instant.now().plusMillis(dur.toMillis()), ZONE_ID_GMT);
    }
}

