/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.impl.Headers;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.Encoding;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValueUtils;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JsonUtils {
    public static final String EMPTY_JSON = "{}";
    private static final String STRING_RE = "\"(.+?)\"";
    private static final String BOOLEAN_RE = "(true|false)";
    private static final String INTEGER_RE = "(-?\\d+)";
    private static final String STRING_ARRAY_RE = "\\[\\s*(\".+?\")\\s*\\]";
    private static final String NUMBER_ARRAY_RE = "\\[\\s*(.+?)\\s*\\]";
    private static final String BEFORE_FIELD_RE = "\"";
    private static final String AFTER_FIELD_RE = "\"\\s*:\\s*";
    private static final String Q = "\"";
    private static final String QCOLONQ = "\":\"";
    private static final String QCOLON = "\":";
    private static final String QCOMMA = "\",";
    private static final String COMMA = ",";
    public static final String OPENQ = "{\"";
    public static final String CLOSE = "}";
    private static final int INDENT_WIDTH = 4;
    private static final String INDENT = "                                        ";

    private JsonUtils() {
    }

    public static StringBuilder beginJson() {
        return new StringBuilder("{");
    }

    public static StringBuilder beginArray() {
        return new StringBuilder("[");
    }

    public static StringBuilder beginJsonPrefixed(String prefix) {
        return prefix == null ? JsonUtils.beginJson() : new StringBuilder(prefix).append('{');
    }

    public static StringBuilder endJson(StringBuilder sb) {
        int lastIndex = sb.length() - 1;
        if (sb.charAt(lastIndex) == ',') {
            sb.setCharAt(lastIndex, '}');
            return sb;
        }
        sb.append(CLOSE);
        return sb;
    }

    public static StringBuilder endArray(StringBuilder sb) {
        int lastIndex = sb.length() - 1;
        if (sb.charAt(lastIndex) == ',') {
            sb.setCharAt(lastIndex, ']');
            return sb;
        }
        sb.append("]");
        return sb;
    }

    public static StringBuilder beginFormattedJson() {
        return new StringBuilder("{\n    ");
    }

    public static String endFormattedJson(StringBuilder sb) {
        sb.setLength(sb.length() - 1);
        sb.append("\n}");
        return sb.toString().replaceAll(COMMA, ",\n    ");
    }

    public static void addRawJson(StringBuilder sb, String fname, String json) {
        if (json != null && json.length() > 0) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON);
            sb.append(json);
            sb.append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, String value) {
        if (value != null && value.length() > 0) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLONQ);
            Encoding.jsonEncode(sb, value);
            sb.append(QCOMMA);
        }
    }

    public static void addFieldEvenEmpty(StringBuilder sb, String fname, String value) {
        if (value == null) {
            value = "";
        }
        sb.append("\"");
        Encoding.jsonEncode(sb, fname);
        sb.append(QCOLONQ);
        Encoding.jsonEncode(sb, value);
        sb.append(QCOMMA);
    }

    public static void addField(StringBuilder sb, String fname, Boolean value) {
        if (value != null) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value != false ? "true" : "false").append(COMMA);
        }
    }

    public static void addFldWhenTrue(StringBuilder sb, String fname, Boolean value) {
        if (value != null && value.booleanValue()) {
            JsonUtils.addField(sb, fname, true);
        }
    }

    public static void addField(StringBuilder sb, String fname, Integer value) {
        if (value != null && value >= 0) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGtZero(StringBuilder sb, String fname, Integer value) {
        if (value != null && value > 0) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, Long value) {
        if (value != null && value >= 0L) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGtZero(StringBuilder sb, String fname, Long value) {
        if (value != null && value > 0L) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGteMinusOne(StringBuilder sb, String fname, Long value) {
        if (value != null && value >= -1L) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGreaterThan(StringBuilder sb, String fname, Long value, long gt) {
        if (value != null && value > gt) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldAsNanos(StringBuilder sb, String fname, Duration value) {
        if (value != null && !value.isZero() && !value.isNegative()) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value.toNanos()).append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, JsonSerializable value) {
        if (value != null) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value.toJson()).append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, Map<String, String> map) {
        if (map != null && map.size() > 0) {
            JsonUtils.addField(sb, fname, JsonValueUtils.instance(map));
        }
    }

    public static void addEnumWhenNot(StringBuilder sb, String fname, Enum e, Enum dontAddIfThis) {
        if (e != null && e != dontAddIfThis) {
            JsonUtils.addField(sb, fname, e.toString());
        }
    }

    public static <T> void _addList(StringBuilder sb, String fname, List<T> list, ListAdder<T> adder) {
        sb.append("\"");
        Encoding.jsonEncode(sb, fname);
        sb.append("\":[");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(COMMA);
            }
            adder.append(sb, list.get(i));
        }
        sb.append("],");
    }

    private static void _addEmptyList(StringBuilder sb, String fname) {
        sb.append("\"");
        Encoding.jsonEncode(sb, fname);
        sb.append("\":[],");
    }

    public static void addStrings(StringBuilder sb, String fname, String[] strings) {
        if (strings != null && strings.length > 0) {
            JsonUtils._addStrings(sb, fname, Arrays.asList(strings));
        }
    }

    public static void addStrings(StringBuilder sb, String fname, List<String> strings) {
        if (strings != null && strings.size() > 0) {
            JsonUtils._addStrings(sb, fname, strings);
        }
    }

    private static void _addStrings(StringBuilder sb, String fname, List<String> strings) {
        JsonUtils._addList(sb, fname, strings, (sbs, s) -> {
            sb.append("\"");
            Encoding.jsonEncode(sb, s);
            sb.append("\"");
        });
    }

    public static void addJsons(StringBuilder sb, String fname, List<? extends JsonSerializable> jsons) {
        JsonUtils.addJsons(sb, fname, jsons, false);
    }

    public static void addJsons(StringBuilder sb, String fname, List<? extends JsonSerializable> jsons, boolean addEmptyList) {
        if (jsons != null && !jsons.isEmpty()) {
            JsonUtils._addList(sb, fname, jsons, (sbs, s) -> sbs.append(s.toJson()));
        } else if (addEmptyList) {
            JsonUtils._addEmptyList(sb, fname);
        }
    }

    public static void addDurations(StringBuilder sb, String fname, List<Duration> durations) {
        if (durations != null && durations.size() > 0) {
            JsonUtils._addList(sb, fname, durations, (sbs, dur) -> sbs.append(dur.toNanos()));
        }
    }

    public static void addField(StringBuilder sb, String fname, ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null && !DateTimeUtils.DEFAULT_TIME.equals(zonedDateTime)) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLONQ).append(DateTimeUtils.toRfc3339(zonedDateTime)).append(QCOMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, Headers headers) {
        if (headers != null && headers.size() > 0) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append("\":{");
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                JsonUtils.addStrings(sb, entry.getKey(), entry.getValue());
            }
            JsonUtils.endJson(sb);
            sb.append(COMMA);
        }
    }

    @Deprecated
    public static String normalize(String s) {
        return Character.toString(s.charAt(0)).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String toKey(Class<?> c) {
        return "\"" + c.getSimpleName() + QCOLON;
    }

    @Deprecated
    public static String objectString(String name, Object o) {
        if (o == null) {
            return name + "=null";
        }
        return o.toString();
    }

    private static String indent(int level) {
        return level <= 0 ? "" : INDENT.substring(0, level * 4);
    }

    public static String getFormatted(Object o) {
        String s = o.toString();
        String newline = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        boolean begin_quotes = false;
        boolean opened = false;
        int indentLevel = 0;
        String indent = "";
        block6: for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c == '\"') {
                if (opened) {
                    sb.append(newline).append(indent);
                    opened = false;
                }
                sb.append(c);
                begin_quotes = !begin_quotes;
                continue;
            }
            if (!begin_quotes) {
                switch (c) {
                    case '[': 
                    case '{': {
                        sb.append(c);
                        opened = true;
                        indent = JsonUtils.indent(++indentLevel);
                        continue block6;
                    }
                    case ']': 
                    case '}': {
                        indent = JsonUtils.indent(--indentLevel);
                        sb.append(newline).append(indent);
                        sb.append(c);
                        opened = false;
                        continue block6;
                    }
                    case ':': {
                        sb.append(c).append(" ");
                        continue block6;
                    }
                    case ',': {
                        sb.append(c).append(newline).append(indentLevel > 0 ? indent : "");
                        continue block6;
                    }
                    default: {
                        if (Character.isWhitespace(c)) continue block6;
                        if (!opened) break;
                        sb.append(newline).append(indent);
                        opened = false;
                    }
                }
            }
            sb.append(c).append(c == '\\' ? "" + s.charAt(++x) : "");
        }
        return sb.toString();
    }

    public static void printFormatted(Object o) {
        System.out.println(JsonUtils.getFormatted(o));
    }

    public static Long safeParseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e1) {
            try {
                return Long.parseUnsignedLong(s);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static long safeParseLong(String s, long dflt) {
        Long l = JsonUtils.safeParseLong(s);
        return l == null ? dflt : l;
    }

    @Deprecated
    public static Pattern string_pattern(String field) {
        return JsonUtils.buildPattern(field, STRING_RE);
    }

    @Deprecated
    public static Pattern number_pattern(String field) {
        return JsonUtils.integer_pattern(field);
    }

    @Deprecated
    public static Pattern integer_pattern(String field) {
        return JsonUtils.buildPattern(field, INTEGER_RE);
    }

    @Deprecated
    public static Pattern boolean_pattern(String field) {
        return JsonUtils.buildPattern(field, BOOLEAN_RE);
    }

    @Deprecated
    public static Pattern string_array_pattern(String field) {
        return JsonUtils.buildPattern(field, STRING_ARRAY_RE);
    }

    @Deprecated
    public static Pattern number_array_pattern(String field) {
        return JsonUtils.buildPattern(field, NUMBER_ARRAY_RE);
    }

    @Deprecated
    public static Pattern buildPattern(String fieldName, FieldType type) {
        return JsonUtils.buildPattern(fieldName, type.re);
    }

    @Deprecated
    public static Pattern buildPattern(String fieldName, String typeRE) {
        return Pattern.compile("\"" + fieldName + AFTER_FIELD_RE + typeRE, 2);
    }

    @Deprecated
    public static String getJsonObject(String objectName, String json) {
        return JsonUtils.getJsonObject(objectName, json, EMPTY_JSON);
    }

    @Deprecated
    public static String getJsonObject(String objectName, String json, String dflt) {
        int[] indexes = JsonUtils.getBracketIndexes(objectName, json, '{', '}', 0);
        return indexes == null ? dflt : json.substring(indexes[0], indexes[1] + 1);
    }

    @Deprecated
    public static String removeObject(String json, String objectName) {
        int[] indexes = JsonUtils.getBracketIndexes(objectName, json, '{', '}', 0);
        if (indexes != null) {
            json = json.substring(0, indexes[0]) + "\"rmvd" + objectName.hashCode() + "\":\"\"" + json.substring(indexes[1] + 1);
        }
        return json;
    }

    @Deprecated
    public static List<String> getObjectList(String objectName, String json) {
        ArrayList<String> items = new ArrayList<String>();
        int[] indexes = JsonUtils.getBracketIndexes(objectName, json, '[', ']', -1);
        if (indexes != null) {
            StringBuilder item = new StringBuilder();
            int depth = 0;
            for (int x = indexes[0] + 1; x < indexes[1]; ++x) {
                char c = json.charAt(x);
                if (c == '{') {
                    item.append(c);
                    ++depth;
                    continue;
                }
                if (c == '}') {
                    item.append(c);
                    if (--depth != 0) continue;
                    items.add(item.toString());
                    item.setLength(0);
                    continue;
                }
                if (depth <= 0) continue;
                item.append(c);
            }
        }
        return items;
    }

    private static int[] getBracketIndexes(String objectName, String json, char start, char end, int fromIndex) {
        int[] result = new int[]{-1, -1};
        int objStart = json.indexOf("\"" + objectName + "\"", fromIndex);
        if (objStart != -1) {
            char c;
            int x;
            int startIx;
            if (fromIndex != -1) {
                int colonMark = json.indexOf(58, objStart) + 1;
                startIx = json.indexOf(start, colonMark);
                for (x = colonMark; x < startIx; ++x) {
                    c = json.charAt(x);
                    if (Character.isWhitespace(c)) continue;
                    return JsonUtils.getBracketIndexes(objectName, json, start, end, colonMark);
                }
            } else {
                startIx = json.indexOf(start, objStart);
            }
            int depth = 1;
            for (x = startIx + 1; x < json.length(); ++x) {
                c = json.charAt(x);
                if (c == start) {
                    ++depth;
                    continue;
                }
                if (c != end || --depth != 0) continue;
                result[0] = startIx;
                result[1] = x;
                return result;
            }
        }
        return null;
    }

    @Deprecated
    public static Map<String, String> getMapOfObjects(String json) {
        HashMap<String, String> map = new HashMap<String, String>();
        int s1 = json.indexOf(34);
        while (s1 != -1) {
            int s2 = json.indexOf(34, s1 + 1);
            String key = json.substring(s1 + 1, s2).trim();
            int[] indexes = JsonUtils.getBracketIndexes(key, json, '{', '}', s1);
            if (indexes != null) {
                map.put(key, json.substring(indexes[0], indexes[1] + 1));
                s1 = json.indexOf(34, indexes[1]);
                continue;
            }
            s1 = -1;
        }
        return map;
    }

    @Deprecated
    public static Map<String, List<String>> getMapOfLists(String json) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        int s1 = json.indexOf(34);
        while (s1 != -1) {
            int s2 = json.indexOf(34, s1 + 1);
            String key = json.substring(s1 + 1, s2).trim();
            int[] indexes = JsonUtils.getBracketIndexes(key, json, '[', ']', s1);
            if (indexes != null) {
                map.put(key, JsonUtils.toList(json.substring(indexes[0] + 1, indexes[1])));
                s1 = json.indexOf(34, indexes[1]);
                continue;
            }
            s1 = -1;
        }
        return map;
    }

    @Deprecated
    public static Map<String, Long> getMapOfLongs(String json) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        int s1 = json.indexOf(34);
        while (s1 != -1) {
            int s2 = json.indexOf(34, s1 + 1);
            int c1 = json.indexOf(58, s2);
            int c2 = json.indexOf(44, s2);
            if (c2 == -1) {
                c2 = json.indexOf(125, s2);
            }
            String key = json.substring(s1 + 1, s2).trim();
            long count = JsonUtils.safeParseLong(json.substring(c1 + 1, c2).trim(), 0L);
            map.put(key, count);
            s1 = json.indexOf(34, c2);
        }
        return map;
    }

    @Deprecated
    public static List<String> getStringList(String objectName, String json) {
        String flat = json.replaceAll("\r", "").replaceAll("\n", "");
        Matcher m = JsonUtils.string_array_pattern(objectName).matcher(flat);
        if (m.find()) {
            String arrayString = m.group(1);
            return JsonUtils.toList(arrayString);
        }
        return new ArrayList<String>();
    }

    private static List<String> toList(String arrayString) {
        String[] raw;
        ArrayList<String> list = new ArrayList<String>();
        for (String s : raw = arrayString.split(COMMA)) {
            String cleaned = s.trim().replace("\"", "");
            if (cleaned.length() <= 0) continue;
            list.add(Encoding.jsonDecode(cleaned));
        }
        return list;
    }

    @Deprecated
    public static List<Long> getLongList(String objectName, String json) {
        String flat = json.replaceAll("\r", "").replaceAll("\n", "");
        ArrayList<Long> list = new ArrayList<Long>();
        Matcher m = JsonUtils.number_array_pattern(objectName).matcher(flat);
        if (m.find()) {
            String[] raw;
            String arrayString = m.group(1);
            for (String s : raw = arrayString.split(COMMA)) {
                list.add(JsonUtils.safeParseLong(s.trim()));
            }
        }
        return list;
    }

    @Deprecated
    public static List<Duration> getDurationList(String objectName, String json) {
        List<Long> longs = JsonUtils.getLongList(objectName, json);
        ArrayList<Duration> list = new ArrayList<Duration>(longs.size());
        for (Long l : longs) {
            list.add(Duration.ofNanos(l));
        }
        return list;
    }

    @Deprecated
    public static byte[] simpleMessageBody(String name, Number value) {
        return (OPENQ + name + QCOLON + value + CLOSE).getBytes();
    }

    @Deprecated
    public static byte[] simpleMessageBody(String name, String value) {
        return (OPENQ + name + QCOLONQ + value + "\"" + CLOSE).getBytes();
    }

    @Deprecated
    public static String readString(String json, Pattern pattern) {
        return JsonUtils.readString(json, pattern, null);
    }

    @Deprecated
    public static String readString(String json, Pattern pattern, String dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Encoding.jsonDecode(m.group(1)) : dflt;
    }

    @Deprecated
    public static String readStringMayHaveQuotes(String json, String field, String dflt) {
        String jfield = "\"" + field + "\"";
        int at = json.indexOf(jfield);
        if (at != -1) {
            at = json.indexOf(34, at + jfield.length());
            StringBuilder sb = new StringBuilder();
            while (true) {
                char c;
                if ((c = json.charAt(++at)) == '\\') {
                    char c2;
                    if ((c2 = json.charAt(++at)) == '\"') {
                        sb.append('\"');
                        continue;
                    }
                    sb.append(c);
                    sb.append(c2);
                    continue;
                }
                if (c == '\"') break;
                sb.append(c);
            }
            return Encoding.jsonDecode(sb.toString());
        }
        return dflt;
    }

    @Deprecated
    public static byte[] readBytes(String json, Pattern pattern) {
        String s = JsonUtils.readString(json, pattern, null);
        return s == null ? null : s.getBytes(StandardCharsets.UTF_8);
    }

    @Deprecated
    public static byte[] readBase64(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        String b64 = m.find() ? m.group(1) : null;
        return b64 == null ? null : Base64.getDecoder().decode(b64);
    }

    @Deprecated
    public static boolean readBoolean(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() && Boolean.parseBoolean(m.group(1));
    }

    @Deprecated
    public static Boolean readBoolean(String json, Pattern pattern, Boolean dflt) {
        Matcher m = pattern.matcher(json);
        if (m.find()) {
            return Boolean.parseBoolean(m.group(1));
        }
        return dflt;
    }

    @Deprecated
    public static Integer readInteger(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Integer.valueOf(Integer.parseInt(m.group(1))) : null;
    }

    @Deprecated
    public static int readInt(String json, Pattern pattern, int dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Integer.parseInt(m.group(1)) : dflt;
    }

    @Deprecated
    public static void readInt(String json, Pattern pattern, IntConsumer c) {
        Matcher m = pattern.matcher(json);
        if (m.find()) {
            c.accept(Integer.parseInt(m.group(1)));
        }
    }

    @Deprecated
    public static Long readLong(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() ? JsonUtils.safeParseLong(m.group(1)) : null;
    }

    @Deprecated
    public static long readLong(String json, Pattern pattern, long dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? JsonUtils.safeParseLong(m.group(1), dflt) : dflt;
    }

    @Deprecated
    public static void readLong(String json, Pattern pattern, LongConsumer c) {
        Long l;
        Matcher m = pattern.matcher(json);
        if (m.find() && (l = JsonUtils.safeParseLong(m.group(1))) != null) {
            c.accept(l);
        }
    }

    @Deprecated
    public static ZonedDateTime readDate(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() ? DateTimeUtils.parseDateTime(m.group(1)) : null;
    }

    @Deprecated
    public static Duration readNanos(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Duration.ofNanos(Long.parseLong(m.group(1))) : null;
    }

    @Deprecated
    public static Duration readNanos(String json, Pattern pattern, Duration dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Duration.ofNanos(Long.parseLong(m.group(1))) : dflt;
    }

    @Deprecated
    public static void readNanos(String json, Pattern pattern, Consumer<Duration> c) {
        Matcher m = pattern.matcher(json);
        if (m.find()) {
            c.accept(Duration.ofNanos(Long.parseLong(m.group(1))));
        }
    }

    public static <T> boolean listEquals(List<T> l1, List<T> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        return l1.equals(l2);
    }

    public static boolean mapEquals(Map<String, String> map1, Map<String, String> map2) {
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null || map1.size() != map2.size()) {
            return false;
        }
        for (String key : map1.keySet()) {
            if (Objects.equals(map1.get(key), map2.get(key))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static enum FieldType {
        jsonString("\"(.+?)\""),
        jsonBoolean("(true|false)"),
        jsonInteger("(-?\\d+)"),
        jsonNumber("(-?\\d+)"),
        jsonStringArray("\\[\\s*(\".+?\")\\s*\\]");

        final String re;

        private FieldType(String re) {
            this.re = re;
        }
    }

    public static interface ListAdder<T> {
        public void append(StringBuilder var1, T var2);
    }
}

