/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.Message;
import io.nats.client.MessageTtl;
import io.nats.client.PublishOptions;
import io.nats.client.api.KeyValueOperation;
import io.nats.client.impl.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NatsKeyValueUtil {
    public static final String KV_STREAM_PREFIX = "KV_";
    public static final int KV_STREAM_PREFIX_LEN = "KV_".length();
    public static final String KV_SUBJECT_PREFIX = "$KV.";
    public static final String KV_SUBJECT_SUFFIX = ".>";
    public static final String KV_OPERATION_HEADER_KEY = "KV-Operation";

    private NatsKeyValueUtil() {
    }

    @NotNull
    public static String extractBucketName(String streamName) {
        return streamName.substring(KV_STREAM_PREFIX_LEN);
    }

    @NotNull
    public static String toStreamName(String bucketName) {
        return KV_STREAM_PREFIX + bucketName;
    }

    @NotNull
    public static String toStreamSubject(String bucketName) {
        return KV_SUBJECT_PREFIX + bucketName + KV_SUBJECT_SUFFIX;
    }

    @NotNull
    public static String toKeyPrefix(String bucketName) {
        return KV_SUBJECT_PREFIX + bucketName + ".";
    }

    public static boolean hasPrefix(String bucketName) {
        return bucketName.startsWith(KV_STREAM_PREFIX);
    }

    @NotNull
    public static String trimPrefix(String bucketName) {
        if (bucketName.startsWith(KV_STREAM_PREFIX)) {
            return bucketName.substring(KV_STREAM_PREFIX.length());
        }
        return bucketName;
    }

    @Nullable
    public static String getOperationHeader(Headers h) {
        return h == null ? null : h.getFirst(KV_OPERATION_HEADER_KEY);
    }

    @Nullable
    public static String getNatsMarkerReasonHeader(Headers h) {
        return h == null ? null : h.getFirst("Nats-Marker-Reason");
    }

    @NotNull
    public static KeyValueOperation getOperation(Headers h) {
        KeyValueOperation kvo = null;
        String hs = NatsKeyValueUtil.getOperationHeader(h);
        if (hs != null) {
            kvo = KeyValueOperation.instance(hs);
        }
        if (kvo == null && (hs = NatsKeyValueUtil.getNatsMarkerReasonHeader(h)) != null) {
            kvo = KeyValueOperation.instanceByMarkerReason(hs);
        }
        return kvo == null ? KeyValueOperation.PUT : kvo;
    }

    @NotNull
    public static Headers getDeleteHeaders() {
        return new Headers().put(KV_OPERATION_HEADER_KEY, KeyValueOperation.DELETE.getHeaderValue());
    }

    @NotNull
    public static Headers getPurgeHeaders() {
        return new Headers().put(KV_OPERATION_HEADER_KEY, KeyValueOperation.PURGE.getHeaderValue()).put("Nats-Rollup", "sub");
    }

    @Nullable
    public static PublishOptions getPublishOptions(long expectedRevision, MessageTtl messageTtl) {
        boolean returnNull = true;
        PublishOptions.Builder b = PublishOptions.builder();
        if (expectedRevision > -1L) {
            returnNull = false;
            b.expectedLastSubjectSequence(expectedRevision);
        }
        if (messageTtl != null) {
            returnNull = false;
            b.messageTtl(messageTtl);
        }
        return returnNull ? null : b.build();
    }

    public static class BucketAndKey {
        public final String bucket;
        public final String key;

        public BucketAndKey(Message m) {
            this(m.getSubject());
        }

        public BucketAndKey(String subject) {
            String[] split = subject.split("\\Q.\\E", 3);
            this.bucket = split[1];
            this.key = split[2];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketAndKey that = (BucketAndKey)o;
            if (!this.bucket.equals(that.bucket)) {
                return false;
            }
            return this.key.equals(that.key);
        }

        public int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }
    }
}

