/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.Message;
import io.nats.client.NatsSystemClock;
import io.nats.client.Options;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;

public class NatsRequestCompletableFuture
extends CompletableFuture<Message> {
    private static final long HYDRATION_TIME = 10000000L;
    private static final String CLOSING_MESSAGE = "Future cancelled, connection closing.";
    private static final String CANCEL_MESSAGE = "Future cancelled, response not registered in time, check connection status.";
    private static final long DEFAULT_TIMEOUT_NANOS = Options.DEFAULT_REQUEST_CLEANUP_INTERVAL.toNanos();
    private final CancelAction cancelAction;
    private final long timeOutAfterNanoTime;
    private boolean wasCancelledClosing;
    private boolean wasCancelledTimedOut;
    private final boolean useTimeoutException;

    public NatsRequestCompletableFuture(CancelAction cancelAction, Duration timeout, boolean useTimeoutException) {
        this.cancelAction = cancelAction;
        this.timeOutAfterNanoTime = NatsSystemClock.nanoTime() + 10000000L + (timeout == null ? DEFAULT_TIMEOUT_NANOS : timeout.toNanos());
        this.useTimeoutException = useTimeoutException;
    }

    public void cancelClosing() {
        this.wasCancelledClosing = true;
        this.completeExceptionally(new CancellationException(CLOSING_MESSAGE));
    }

    public void cancelTimedOut() {
        this.wasCancelledTimedOut = true;
        this.completeExceptionally(this.useTimeoutException ? new TimeoutException(CANCEL_MESSAGE) : new CancellationException(CANCEL_MESSAGE));
    }

    public CancelAction getCancelAction() {
        return this.cancelAction;
    }

    public boolean useTimeoutException() {
        return this.useTimeoutException;
    }

    public boolean hasExceededTimeout() {
        return NatsSystemClock.nanoTime() > this.timeOutAfterNanoTime;
    }

    public boolean wasCancelledClosing() {
        return this.wasCancelledClosing;
    }

    public boolean wasCancelledTimedOut() {
        return this.wasCancelledTimedOut;
    }

    public static enum CancelAction {
        CANCEL,
        REPORT,
        COMPLETE;

    }
}

