/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ScheduledTask
implements Runnable {
    private final Runnable runnable;
    protected final AtomicReference<ScheduledFuture<?>> scheduledFutureRef;
    protected final AtomicBoolean keepGoing;

    public ScheduledTask(ScheduledExecutorService ses, long initialAndPeriodMillis, Runnable runnable) {
        this(ses, initialAndPeriodMillis, initialAndPeriodMillis, TimeUnit.MILLISECONDS, runnable);
    }

    public ScheduledTask(ScheduledExecutorService ses, long initialAndPeriod, TimeUnit unit, Runnable runnable) {
        this(ses, initialAndPeriod, initialAndPeriod, unit, runnable);
    }

    public ScheduledTask(ScheduledExecutorService ses, long initialDelay, long period, TimeUnit unit, Runnable runnable) {
        this.runnable = runnable;
        this.keepGoing = new AtomicBoolean(true);
        this.scheduledFutureRef = new AtomicReference(ses.scheduleAtFixedRate(this, initialDelay, period, unit));
    }

    @Override
    public void run() {
        if (this.keepGoing.get() && !Thread.interrupted()) {
            this.runnable.run();
        }
    }

    public void shutdown() {
        try {
            this.keepGoing.getAndSet(false);
            ScheduledFuture<?> f = this.scheduledFutureRef.get();
            this.scheduledFutureRef.set(null);
            if (f != null) {
                f.cancel(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

