/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.Replica;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ClusterInfo {
    private final String name;
    private final String leader;
    private final List<Replica> replicas;

    static ClusterInfo optionalInstance(JsonValue v) {
        return v == null ? null : new ClusterInfo(v);
    }

    ClusterInfo(JsonValue v) {
        this.name = JsonValueUtils.readString(v, "name");
        this.leader = JsonValueUtils.readString(v, "leader");
        this.replicas = Replica.optionalListOf(JsonValueUtils.readValue(v, "replicas"));
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getLeader() {
        return this.leader;
    }

    @Nullable
    public List<Replica> getReplicas() {
        return this.replicas;
    }

    public String toString() {
        return "ClusterInfo{name='" + this.name + '\'' + ", leader='" + this.leader + '\'' + ", replicas=" + this.replicas + '}';
    }
}

